/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransCallNamedPipe
extends SmbComTransaction {
    private static final Logger log = LoggerFactory.getLogger(TransCallNamedPipe.class);
    private final byte[] pipeData;
    private final int pipeDataOff;
    private final int pipeDataLen;

    public TransCallNamedPipe(Configuration config, String pipeName, byte[] data, int off, int len) {
        super(config, (byte)37, (byte)84);
        this.name = pipeName;
        this.pipeData = data;
        this.pipeDataOff = off;
        this.pipeDataLen = len;
        this.timeout = -1;
        this.maxParameterCount = 0;
        this.maxDataCount = 65535;
        this.maxSetupCount = 0;
        this.setupCount = 2;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.getSubCommand();
        int n = ++dstIndex;
        dst[n] = 0;
        int n2 = ++dstIndex;
        dst[n2] = 0;
        int n3 = ++dstIndex;
        ++dstIndex;
        dst[n3] = 0;
        return 4;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        if (dst.length - dstIndex < this.pipeDataLen) {
            log.debug("TransCallNamedPipe data too long for buffer");
            return 0;
        }
        System.arraycopy(this.pipeData, this.pipeDataOff, dst, dstIndex, this.pipeDataLen);
        return this.pipeDataLen;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "TransCallNamedPipe[" + super.toString() + ",pipeName=" + this.name + "]";
    }
}

