/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComSetInformation
extends ServerMessageBlock {
    private final int fileAttributes;
    private final long lastWriteTime;

    public SmbComSetInformation(Configuration config, String filename, int attrs, long mtime) {
        super(config, (byte)9, filename);
        this.fileAttributes = attrs;
        this.lastWriteTime = mtime;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fileAttributes, dst, dstIndex);
        SMBUtil.writeUTime(this.lastWriteTime, dst, dstIndex += 2);
        dstIndex += 4;
        return (dstIndex += 10) - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex] = 4;
        ++dstIndex;
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComSetInformation[" + super.toString() + ",filename=" + this.path + ",fileAttributes=" + this.fileAttributes + ",lastWriteTime=" + this.lastWriteTime + "]";
    }
}

