/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.security.GeneralSecurityException;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.impl.NtlmPasswordAuthenticator;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.com.ServerData;
import org.codelibs.jcifs.smb.internal.smb1.com.SmbComNegotiateResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComSessionSetupAndX
extends AndXServerMessageBlock {
    private byte[] lmHash;
    private byte[] ntHash;
    private byte[] blob = null;
    private String accountName;
    private String primaryDomain;
    private final SmbComNegotiateResponse negotiated;
    private int capabilities;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SmbComSessionSetupAndX(CIFSContext tc, SmbComNegotiateResponse negotiated, ServerMessageBlock andx, Object cred) throws SmbException, GeneralSecurityException {
        super(tc.getConfig(), (byte)115, andx);
        this.negotiated = negotiated;
        this.capabilities = negotiated.getNegotiatedCapabilities();
        ServerData server = negotiated.getServerData();
        if (server.security == 1) {
            if (cred instanceof NtlmPasswordAuthenticator) {
                NtlmPasswordAuthenticator a = (NtlmPasswordAuthenticator)cred;
                if (a.isAnonymous()) {
                    this.lmHash = new byte[0];
                    this.ntHash = new byte[0];
                    this.capabilities &= Integer.MAX_VALUE;
                    if (a.isGuest()) {
                        this.accountName = a.getUsername();
                        if (this.isUseUnicode()) {
                            this.accountName = this.accountName.toUpperCase();
                        }
                        this.primaryDomain = a.getUserDomain() != null ? a.getUserDomain().toUpperCase() : "?";
                        return;
                    } else {
                        this.accountName = "";
                        this.primaryDomain = "";
                    }
                    return;
                } else {
                    this.accountName = a.getUsername();
                    if (this.isUseUnicode()) {
                        this.accountName = this.accountName.toUpperCase();
                    }
                    String string = this.primaryDomain = a.getUserDomain() != null ? a.getUserDomain().toUpperCase() : "?";
                    if (server.encryptedPasswords) {
                        this.lmHash = a.getAnsiHash(tc, server.encryptionKey);
                        this.ntHash = a.getUnicodeHash(tc, server.encryptionKey);
                        if (this.lmHash.length != 0 || this.ntHash.length != 0) return;
                        throw new RuntimeException("Null setup prohibited.");
                    }
                    if (tc.getConfig().isDisablePlainTextPasswords()) {
                        throw new RuntimeException("Plain text passwords are disabled");
                    }
                    String password = a.getPassword();
                    this.lmHash = new byte[(password.length() + 1) * 2];
                    this.ntHash = new byte[0];
                    this.writeString(password, this.lmHash, 0);
                }
                return;
            } else {
                if (!(cred instanceof byte[])) throw new SmbException("Unsupported credential type " + String.valueOf(cred != null ? cred.getClass() : "NULL"));
                this.blob = (byte[])cred;
            }
            return;
        } else {
            if (server.security != 0) throw new SmbException("Unsupported");
            if (!(cred instanceof NtlmPasswordAuthenticator)) {
                throw new SmbException("Unsupported credential type");
            }
            NtlmPasswordAuthenticator a = (NtlmPasswordAuthenticator)cred;
            this.lmHash = new byte[0];
            this.ntHash = new byte[0];
            if (!a.isAnonymous()) {
                this.accountName = a.getUsername();
                if (this.isUseUnicode()) {
                    this.accountName = this.accountName.toUpperCase();
                }
                this.primaryDomain = a.getUserDomain() != null ? a.getUserDomain().toUpperCase() : "?";
                return;
            } else {
                this.accountName = "";
                this.primaryDomain = "";
            }
        }
    }

    @Override
    protected int getBatchLimit(Configuration cfg, byte cmd) {
        return cmd == 117 ? cfg.getBatchLimit("SessionSetupAndX.TreeConnectAndX") : 0;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.negotiated.getNegotiatedSendBufferSize(), dst, dstIndex);
        SMBUtil.writeInt2(this.negotiated.getNegotiatedMpxCount(), dst, dstIndex += 2);
        SMBUtil.writeInt2(this.getConfig().getVcNumber(), dst, dstIndex += 2);
        SMBUtil.writeInt4(this.negotiated.getNegotiatedSessionKey(), dst, dstIndex += 2);
        dstIndex += 4;
        if (this.blob != null) {
            SMBUtil.writeInt2(this.blob.length, dst, dstIndex);
        } else {
            SMBUtil.writeInt2(this.lmHash.length, dst, dstIndex);
            SMBUtil.writeInt2(this.ntHash.length, dst, dstIndex += 2);
        }
        dst[dstIndex += 2] = 0;
        int n = ++dstIndex;
        dst[n] = 0;
        int n2 = ++dstIndex;
        dst[n2] = 0;
        int n3 = ++dstIndex;
        dst[n3] = 0;
        SMBUtil.writeInt4(this.capabilities, dst, ++dstIndex);
        return (dstIndex += 4) - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.blob != null) {
            System.arraycopy(this.blob, 0, dst, dstIndex, this.blob.length);
            dstIndex += this.blob.length;
        } else {
            System.arraycopy(this.lmHash, 0, dst, dstIndex, this.lmHash.length);
            System.arraycopy(this.ntHash, 0, dst, dstIndex += this.lmHash.length, this.ntHash.length);
            dstIndex += this.ntHash.length;
            dstIndex += this.writeString(this.accountName, dst, dstIndex);
            dstIndex += this.writeString(this.primaryDomain, dst, dstIndex);
        }
        dstIndex += this.writeString(this.getConfig().getNativeOs(), dst, dstIndex);
        dstIndex += this.writeString(this.getConfig().getNativeLanman(), dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComSessionSetupAndX[" + super.toString() + ",snd_buf_size=" + this.negotiated.getNegotiatedSendBufferSize() + ",maxMpxCount=" + this.negotiated.getNegotiatedMpxCount() + ",VC_NUMBER=" + this.getConfig().getVcNumber() + ",sessionKey=" + this.negotiated.getNegotiatedSessionKey() + ",lmHash.length=" + (this.lmHash == null ? 0 : this.lmHash.length) + ",ntHash.length=" + (this.ntHash == null ? 0 : this.ntHash.length) + ",capabilities=" + this.capabilities + ",accountName=" + this.accountName + ",primaryDomain=" + this.primaryDomain + ",NATIVE_OS=" + this.getConfig().getNativeOs() + ",NATIVE_LANMAN=" + this.getConfig().getNativeLanman() + "]";
    }
}

