/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.util.Date;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SmbBasicFileInfo;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class SmbComQueryInformationResponse
extends ServerMessageBlock
implements SmbBasicFileInfo {
    private int fileAttributes = 0;
    private long lastWriteTime = 0L;
    private final long serverTimeZoneOffset;
    private int fileSize = 0;

    public SmbComQueryInformationResponse(Configuration config, long serverTimeZoneOffset) {
        super(config, (byte)8);
        this.serverTimeZoneOffset = serverTimeZoneOffset;
    }

    @Override
    public int getAttributes() {
        return this.fileAttributes;
    }

    @Override
    public long getCreateTime() {
        return this.convertTime(this.lastWriteTime);
    }

    private long convertTime(long time) {
        return time + this.serverTimeZoneOffset;
    }

    @Override
    public long getLastWriteTime() {
        return this.convertTime(this.lastWriteTime);
    }

    @Override
    public long getLastAccessTime() {
        return this.convertTime(this.lastWriteTime);
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        if (this.wordCount == 0) {
            return 0;
        }
        this.fileAttributes = SMBUtil.readInt2(buffer, bufferIndex);
        this.lastWriteTime = SMBUtil.readUTime(buffer, bufferIndex += 2);
        this.fileSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        return 20;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComQueryInformationResponse[" + super.toString() + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",lastWriteTime=" + String.valueOf(new Date(this.lastWriteTime)) + ",fileSize=" + this.fileSize + "]";
    }
}

