/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SmbBasicFileInfo;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.com.SmbComSeekResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbComOpenAndXResponse
extends AndXServerMessageBlock
implements SmbBasicFileInfo {
    private int fid;
    private int fileAttributes;
    private int fileDataSize;
    private int grantedAccess;
    private int fileType;
    private int deviceState;
    private int action;
    private int serverFid;
    private long lastWriteTime;

    public SmbComOpenAndXResponse(Configuration config) {
        super(config);
    }

    public SmbComOpenAndXResponse(Configuration config, SmbComSeekResponse andxResp) {
        super(config, andxResp);
    }

    public final int getFid() {
        return this.fid;
    }

    public final int getDataSize() {
        return this.fileDataSize;
    }

    @Override
    public long getSize() {
        return this.getDataSize();
    }

    public final int getGrantedAccess() {
        return this.grantedAccess;
    }

    public final int getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    public int getAttributes() {
        return this.getFileAttributes();
    }

    public final int getFileType() {
        return this.fileType;
    }

    public final int getDeviceState() {
        return this.deviceState;
    }

    public final int getAction() {
        return this.action;
    }

    public final int getServerFid() {
        return this.serverFid;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public long getCreateTime() {
        return 0L;
    }

    @Override
    public long getLastAccessTime() {
        return 0L;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.fid = SMBUtil.readInt2(buffer, bufferIndex);
        this.fileAttributes = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.lastWriteTime = SMBUtil.readUTime(buffer, bufferIndex += 2);
        this.fileDataSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.grantedAccess = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.fileType = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.deviceState = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.action = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.serverFid = SMBUtil.readInt4(buffer, bufferIndex += 2);
        return (bufferIndex += 6) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComOpenAndXResponse[" + super.toString() + ",fid=" + this.fid + ",fileAttributes=" + this.fileAttributes + ",lastWriteTime=" + this.lastWriteTime + ",dataSize=" + this.fileDataSize + ",grantedAccess=" + this.grantedAccess + ",fileType=" + this.fileType + ",deviceState=" + this.deviceState + ",action=" + this.action + ",serverFid=" + this.serverFid + "]";
    }
}

