/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.util.Date;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SmbBasicFileInfo;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class SmbComNTCreateAndXResponse
extends AndXServerMessageBlock
implements SmbBasicFileInfo {
    static final int EXCLUSIVE_OPLOCK_GRANTED = 1;
    static final int BATCH_OPLOCK_GRANTED = 2;
    static final int LEVEL_II_OPLOCK_GRANTED = 3;
    private byte oplockLevel;
    private int fid;
    private int createAction;
    private int extFileAttributes;
    private int fileType;
    private int deviceState;
    private long creationTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private long allocationSize;
    private long endOfFile;
    private boolean directory;
    private boolean isExtended;

    public SmbComNTCreateAndXResponse(Configuration config) {
        super(config);
    }

    public final int getFileType() {
        return this.fileType;
    }

    public final boolean isExtended() {
        return this.isExtended;
    }

    public final void setExtended(boolean isExtended) {
        this.isExtended = isExtended;
    }

    public final byte getOplockLevel() {
        return this.oplockLevel;
    }

    public final int getFid() {
        return this.fid;
    }

    public final int getCreateAction() {
        return this.createAction;
    }

    public final int getExtFileAttributes() {
        return this.extFileAttributes;
    }

    @Override
    public int getAttributes() {
        return this.getExtFileAttributes();
    }

    public final int getDeviceState() {
        return this.deviceState;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getCreateTime() {
        return this.getCreationTime();
    }

    @Override
    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final long getAllocationSize() {
        return this.allocationSize;
    }

    public final long getEndOfFile() {
        return this.endOfFile;
    }

    @Override
    public long getSize() {
        return this.getEndOfFile();
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.oplockLevel = buffer[bufferIndex];
        this.fid = SMBUtil.readInt2(buffer, ++bufferIndex);
        this.createAction = SMBUtil.readInt4(buffer, bufferIndex += 2);
        this.creationTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.extFileAttributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        this.allocationSize = SMBUtil.readInt8(buffer, bufferIndex += 4);
        this.endOfFile = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.fileType = SMBUtil.readInt2(buffer, bufferIndex += 8);
        this.deviceState = SMBUtil.readInt2(buffer, bufferIndex += 2);
        bufferIndex += 2;
        this.directory = (buffer[bufferIndex++] & 0xFF) > 0;
        return bufferIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "SmbComNTCreateAndXResponse[" + super.toString() + ",oplockLevel=" + this.oplockLevel + ",fid=" + this.fid + ",createAction=0x" + Hexdump.toHexString(this.createAction, 4) + ",creationTime=" + String.valueOf(new Date(this.creationTime)) + ",lastAccessTime=" + String.valueOf(new Date(this.lastAccessTime)) + ",lastWriteTime=" + String.valueOf(new Date(this.lastWriteTime)) + ",changeTime=" + String.valueOf(new Date(this.changeTime)) + ",extFileAttributes=0x" + Hexdump.toHexString(this.extFileAttributes, 4) + ",allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",fileType=" + this.fileType + ",deviceState=" + this.deviceState + ",directory=" + this.directory + "]";
    }
}

