/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import org.codelibs.jcifs.smb.Decodable;
import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class LockingAndXRange
implements Encodable,
Decodable {
    private final boolean largeFile;
    private int pid;
    private long byteOffset;
    private long lengthInBytes;

    public LockingAndXRange(boolean largeFile) {
        this.largeFile = largeFile;
    }

    public int getPid() {
        return this.pid;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public long getLengthInBytes() {
        return this.lengthInBytes;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        if (this.largeFile) {
            this.pid = SMBUtil.readInt2(buffer, bufferIndex);
            int boHigh = SMBUtil.readInt4(buffer, bufferIndex + 4);
            int boLow = SMBUtil.readInt4(buffer, bufferIndex + 8);
            this.byteOffset = boHigh << 32 | boLow;
            int lHigh = SMBUtil.readInt4(buffer, bufferIndex + 12);
            int lLow = SMBUtil.readInt4(buffer, bufferIndex + 16);
            this.lengthInBytes = lHigh << 32 | lLow;
            return 20;
        }
        this.pid = SMBUtil.readInt2(buffer, bufferIndex);
        this.byteOffset = SMBUtil.readInt4(buffer, bufferIndex + 2);
        this.lengthInBytes = SMBUtil.readInt4(buffer, bufferIndex + 6);
        return 10;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        if (this.largeFile) {
            SMBUtil.writeInt2(this.pid, dst, dstIndex);
            SMBUtil.writeInt4(this.byteOffset >> 32, dst, dstIndex + 4);
            SMBUtil.writeInt4(this.byteOffset & 0xFFFFFFFFFFFFFFFFL, dst, dstIndex + 8);
            SMBUtil.writeInt4(this.lengthInBytes >> 32, dst, dstIndex + 12);
            SMBUtil.writeInt4(this.lengthInBytes & 0xFFFFFFFFFFFFFFFFL, dst, dstIndex + 16);
            return 20;
        }
        SMBUtil.writeInt2(this.pid, dst, dstIndex);
        SMBUtil.writeInt4(this.byteOffset, dst, dstIndex + 2);
        SMBUtil.writeInt4(this.lengthInBytes, dst, dstIndex + 6);
        return 10;
    }

    @Override
    public int size() {
        return this.largeFile ? 20 : 10;
    }
}

