/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.RuntimeCIFSException;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlock;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockResponse;
import org.codelibs.jcifs.smb.internal.RequestWithPath;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.SMBSigningDigest;
import org.codelibs.jcifs.smb.internal.smb1.SMB1SigningDigest;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;
import org.codelibs.jcifs.smb.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerMessageBlock
implements CommonServerMessageBlockRequest,
CommonServerMessageBlockResponse,
RequestWithPath {
    private static final Logger log = LoggerFactory.getLogger(ServerMessageBlock.class);
    public static final byte SMB_COM_CREATE_DIRECTORY = 0;
    public static final byte SMB_COM_DELETE_DIRECTORY = 1;
    public static final byte SMB_COM_CLOSE = 4;
    public static final byte SMB_COM_DELETE = 6;
    public static final byte SMB_COM_RENAME = 7;
    public static final byte SMB_COM_QUERY_INFORMATION = 8;
    public static final byte SMB_COM_SET_INFORMATION = 9;
    public static final byte SMB_COM_WRITE = 11;
    public static final byte SMB_COM_CHECK_DIRECTORY = 16;
    public static final byte SMB_COM_SEEK = 18;
    public static final byte SMB_COM_LOCKING_ANDX = 36;
    public static final byte SMB_COM_TRANSACTION = 37;
    public static final byte SMB_COM_TRANSACTION_SECONDARY = 38;
    public static final byte SMB_COM_MOVE = 42;
    public static final byte SMB_COM_ECHO = 43;
    public static final byte SMB_COM_OPEN_ANDX = 45;
    public static final byte SMB_COM_READ_ANDX = 46;
    public static final byte SMB_COM_WRITE_ANDX = 47;
    public static final byte SMB_COM_TRANSACTION2 = 50;
    public static final byte SMB_COM_FIND_CLOSE2 = 52;
    public static final byte SMB_COM_TREE_DISCONNECT = 113;
    public static final byte SMB_COM_NEGOTIATE = 114;
    public static final byte SMB_COM_SESSION_SETUP_ANDX = 115;
    public static final byte SMB_COM_LOGOFF_ANDX = 116;
    public static final byte SMB_COM_TREE_CONNECT_ANDX = 117;
    public static final byte SMB_COM_NT_TRANSACT = -96;
    public static final byte SMB_COM_NT_CANCEL = -92;
    public static final byte SMB_COM_NT_TRANSACT_SECONDARY = -95;
    public static final byte SMB_COM_NT_CREATE_ANDX = -94;
    private byte command;
    private byte flags;
    protected int headerStart;
    protected int length;
    protected int batchLevel;
    protected int errorCode;
    protected int flags2;
    protected int pid;
    protected int uid;
    protected int mid;
    protected int wordCount;
    protected int byteCount;
    protected int tid = 65535;
    private boolean useUnicode;
    private boolean forceUnicode;
    private boolean extendedSecurity;
    private volatile boolean received;
    private int signSeq;
    private boolean verifyFailed;
    protected String path;
    protected SMB1SigningDigest digest = null;
    private ServerMessageBlock response;
    private final Configuration config;
    private Long expiration;
    private Exception exception;
    private boolean isError;
    private byte[] rawPayload;
    private boolean retainPayload;
    private String fullPath;
    private String server;
    private String domain;
    private Integer overrideTimeout;

    protected ServerMessageBlock(Configuration config) {
        this(config, 0);
    }

    protected ServerMessageBlock(Configuration config, byte command) {
        this(config, command, null);
    }

    protected ServerMessageBlock(Configuration config, byte command, String path) {
        this.config = config;
        this.command = command;
        this.path = path;
        this.flags = (byte)24;
        this.pid = config.getPid();
        this.batchLevel = 0;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isResponseAsync() {
        return false;
    }

    @Override
    public final Integer getOverrideTimeout() {
        return this.overrideTimeout;
    }

    public final void setOverrideTimeout(Integer overrideTimeout) {
        this.overrideTimeout = overrideTimeout;
    }

    @Override
    public ServerMessageBlock getNext() {
        return null;
    }

    @Override
    public boolean allowChain(CommonServerMessageBlockRequest next) {
        return false;
    }

    @Override
    public CommonServerMessageBlockRequest split() {
        return null;
    }

    @Override
    public CommonServerMessageBlockRequest createCancel() {
        return null;
    }

    @Override
    public CommonServerMessageBlockResponse getNextResponse() {
        return null;
    }

    @Override
    public void prepare(CommonServerMessageBlockRequest next) {
    }

    @Override
    public int getCreditCost() {
        return 1;
    }

    @Override
    public int getGrantedCredits() {
        return 1;
    }

    @Override
    public void setRequestCredits(int credits) {
    }

    @Override
    public final int getCommand() {
        return this.command;
    }

    @Override
    public final void setCommand(int command) {
        this.command = (byte)command;
    }

    public final int getByteCount() {
        return this.byteCount;
    }

    public final int getLength() {
        return this.length;
    }

    public boolean isForceUnicode() {
        return this.forceUnicode;
    }

    public final byte getFlags() {
        return this.flags;
    }

    public final void setFlags(byte flags) {
        this.flags = flags;
    }

    public final int getFlags2() {
        return this.flags2;
    }

    public final void setFlags2(int fl) {
        this.flags2 = fl;
    }

    public final void addFlags2(int fl) {
        this.flags2 |= fl;
    }

    public final void remFlags2(int fl) {
        this.flags2 &= ~fl;
    }

    @Override
    public void setResolveInDfs(boolean resolve) {
        if (resolve) {
            this.addFlags2(4096);
        } else {
            this.remFlags2(4096);
        }
    }

    @Override
    public boolean isResolveInDfs() {
        return (this.getFlags() & 0x1000) == 4096;
    }

    @Override
    public final int getErrorCode() {
        return this.errorCode;
    }

    public final void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public final String getPath() {
        return this.path;
    }

    @Override
    public String getFullUNCPath() {
        return this.fullPath;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void setFullUNCPath(String domain, String server, String fullPath) {
        this.domain = domain;
        this.server = server;
        this.fullPath = fullPath;
    }

    @Override
    public final void setPath(String path) {
        this.path = path;
    }

    @Override
    public final SMB1SigningDigest getDigest() {
        return this.digest;
    }

    @Override
    public final void setDigest(SMBSigningDigest digest) {
        this.digest = (SMB1SigningDigest)digest;
    }

    public boolean isExtendedSecurity() {
        return this.extendedSecurity;
    }

    @Override
    public final void setSessionId(long sessionId) {
    }

    @Override
    public void setExtendedSecurity(boolean extendedSecurity) {
        this.extendedSecurity = extendedSecurity;
    }

    public final boolean isUseUnicode() {
        return this.useUnicode;
    }

    public final void setUseUnicode(boolean useUnicode) {
        this.useUnicode = useUnicode;
    }

    @Override
    public final boolean isReceived() {
        return this.received;
    }

    @Override
    public final void clearReceived() {
        this.received = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received() {
        this.received = true;
        ServerMessageBlock serverMessageBlock = this;
        synchronized (serverMessageBlock) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(Exception e) {
        this.exception = e;
        ServerMessageBlock serverMessageBlock = this;
        synchronized (serverMessageBlock) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error() {
        this.isError = true;
        ServerMessageBlock serverMessageBlock = this;
        synchronized (serverMessageBlock) {
            this.notifyAll();
        }
    }

    @Override
    public ServerMessageBlock getResponse() {
        return this.response;
    }

    public CommonServerMessageBlock ignoreDisconnect() {
        return this;
    }

    @Override
    public final void setResponse(CommonServerMessageBlockResponse response) {
        if (!(response instanceof ServerMessageBlock)) {
            throw new IllegalArgumentException();
        }
        this.response = (ServerMessageBlock)response;
    }

    @Override
    public boolean isCancel() {
        return false;
    }

    @Override
    public final long getMid() {
        return this.mid;
    }

    @Override
    public final void setMid(long mid) {
        this.mid = (int)mid;
    }

    public final int getTid() {
        return this.tid;
    }

    @Override
    public final void setTid(int tid) {
        this.tid = tid;
    }

    public final int getPid() {
        return this.pid;
    }

    public final void setPid(int pid) {
        this.pid = pid;
    }

    public final int getUid() {
        return this.uid;
    }

    @Override
    public final void setUid(int uid) {
        this.uid = uid;
    }

    public int getSignSeq() {
        return this.signSeq;
    }

    public final void setSignSeq(int signSeq) {
        this.signSeq = signSeq;
    }

    @Override
    public boolean isVerifyFailed() {
        return this.verifyFailed;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    @Override
    public byte[] getRawPayload() {
        return this.rawPayload;
    }

    @Override
    public void setRawPayload(byte[] rawPayload) {
        this.rawPayload = rawPayload;
    }

    @Override
    public boolean isRetainPayload() {
        return this.retainPayload;
    }

    @Override
    public void retainPayload() {
        this.retainPayload = true;
    }

    @Override
    public Long getExpiration() {
        return this.expiration;
    }

    @Override
    public void setExpiration(Long exp) {
        this.expiration = exp;
    }

    protected final Configuration getConfig() {
        return this.config;
    }

    @Override
    public void reset() {
        this.flags = (byte)24;
        this.flags2 = 0;
        this.errorCode = 0;
        this.received = false;
        this.digest = null;
        this.uid = 0;
        this.tid = 65535;
    }

    @Override
    public boolean verifySignature(byte[] buffer, int i, int size) {
        if (this.digest != null && this.getErrorCode() == 0) {
            boolean verify;
            this.verifyFailed = verify = this.digest.verify(buffer, i, size, 0, this);
            return !verify;
        }
        return true;
    }

    protected int writeString(String str, byte[] dst, int dstIndex) {
        return this.writeString(str, dst, dstIndex, this.useUnicode);
    }

    protected int writeString(String str, byte[] dst, int dstIndex, boolean unicode) {
        int start = dstIndex;
        if (unicode) {
            if ((dstIndex - this.headerStart) % 2 != 0) {
                dst[dstIndex++] = 0;
            }
            System.arraycopy(Strings.getUNIBytes(str), 0, dst, dstIndex, str.length() * 2);
            dst[dstIndex += str.length() * 2] = 0;
            int n = ++dstIndex;
            ++dstIndex;
            dst[n] = 0;
        } else {
            byte[] b = Strings.getOEMBytes(str, this.getConfig());
            System.arraycopy(b, 0, dst, dstIndex, b.length);
            dst[dstIndex += b.length] = 0;
            ++dstIndex;
        }
        return dstIndex - start;
    }

    public String readString(byte[] src, int srcIndex) {
        return this.readString(src, srcIndex, 255, this.useUnicode);
    }

    public String readString(byte[] src, int srcIndex, int maxLen, boolean unicode) {
        if (unicode) {
            if ((srcIndex - this.headerStart) % 2 != 0) {
                ++srcIndex;
            }
            return Strings.fromUNIBytes(src, srcIndex, Strings.findUNITermination(src, srcIndex, maxLen));
        }
        return Strings.fromOEMBytes(src, srcIndex, Strings.findTermination(src, srcIndex, maxLen), this.getConfig());
    }

    public String readString(byte[] src, int srcIndex, int srcEnd, int maxLen, boolean unicode) {
        if (unicode) {
            if ((srcIndex - this.headerStart) % 2 != 0) {
                ++srcIndex;
            }
            return Strings.fromUNIBytes(src, srcIndex, Strings.findUNITermination(src, srcIndex, maxLen));
        }
        return Strings.fromOEMBytes(src, srcIndex, Strings.findTermination(src, srcIndex, maxLen), this.getConfig());
    }

    public int stringWireLength(String str, int offset) {
        int len = str.length() + 1;
        if (this.useUnicode) {
            len = str.length() * 2 + 2;
            len = offset % 2 != 0 ? len + 1 : len;
        }
        return len;
    }

    protected int readStringLength(byte[] src, int srcIndex, int max) {
        int len = 0;
        while (src[srcIndex + len] != 0) {
            if (len++ <= max) continue;
            throw new RuntimeCIFSException("zero termination not found: " + String.valueOf(this));
        }
        return len;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        this.wordCount = this.writeParameterWordsWireFormat(dst, dstIndex + 1);
        dst[dstIndex] = (byte)(this.wordCount / 2 & 0xFF);
        ++dstIndex;
        this.wordCount /= 2;
        this.byteCount = this.writeBytesWireFormat(dst, (dstIndex += this.wordCount) + 2);
        dst[dstIndex++] = (byte)(this.byteCount & 0xFF);
        dst[dstIndex++] = (byte)(this.byteCount >> 8 & 0xFF);
        this.length = (dstIndex += this.byteCount) - start;
        if (this.digest != null) {
            this.digest.sign(dst, this.headerStart, this.length, this, this.response);
        }
        return this.length;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int len;
        int n;
        int start = this.headerStart = bufferIndex;
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        this.wordCount = buffer[bufferIndex];
        ++bufferIndex;
        if (this.wordCount != 0) {
            n = this.readParameterWordsWireFormat(buffer, bufferIndex);
            if (n != this.wordCount * 2 && log.isTraceEnabled()) {
                log.trace("wordCount * 2=" + this.wordCount * 2 + " but readParameterWordsWireFormat returned " + n);
            }
            bufferIndex += this.wordCount * 2;
        }
        this.byteCount = SMBUtil.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.byteCount != 0) {
            n = this.readBytesWireFormat(buffer, bufferIndex);
            if (n != this.byteCount && log.isTraceEnabled()) {
                log.trace("byteCount=" + this.byteCount + " but readBytesWireFormat returned " + n);
            }
            bufferIndex += this.byteCount;
        }
        this.length = len = bufferIndex - start;
        if (this.isRetainPayload()) {
            byte[] payload = new byte[len];
            System.arraycopy(buffer, 4, payload, 0, len);
            this.setRawPayload(payload);
        }
        if (!this.verifySignature(buffer, 4, len)) {
            throw new SMBProtocolDecodingException("Signature verification failed for " + this.getClass().getName());
        }
        return len;
    }

    protected int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        System.arraycopy(SMBUtil.SMB_HEADER, 0, dst, dstIndex, SMBUtil.SMB_HEADER.length);
        dst[dstIndex + 4] = this.command;
        dst[dstIndex + 9] = this.flags;
        SMBUtil.writeInt2(this.flags2, dst, dstIndex + 9 + 1);
        SMBUtil.writeInt2(this.tid, dst, dstIndex += 24);
        SMBUtil.writeInt2(this.pid, dst, dstIndex + 2);
        SMBUtil.writeInt2(this.uid, dst, dstIndex + 4);
        SMBUtil.writeInt2(this.mid, dst, dstIndex + 6);
        return 32;
    }

    protected int readHeaderWireFormat(byte[] buffer, int bufferIndex) {
        this.command = buffer[bufferIndex + 4];
        this.errorCode = SMBUtil.readInt4(buffer, bufferIndex + 5);
        this.flags = buffer[bufferIndex + 9];
        this.flags2 = SMBUtil.readInt2(buffer, bufferIndex + 9 + 1);
        this.tid = SMBUtil.readInt2(buffer, bufferIndex + 24);
        this.pid = SMBUtil.readInt2(buffer, bufferIndex + 24 + 2);
        this.uid = SMBUtil.readInt2(buffer, bufferIndex + 24 + 4);
        this.mid = SMBUtil.readInt2(buffer, bufferIndex + 24 + 6);
        return 32;
    }

    protected boolean isResponse() {
        return (this.flags & 0x80) == 128;
    }

    protected abstract int writeParameterWordsWireFormat(byte[] var1, int var2);

    protected abstract int writeBytesWireFormat(byte[] var1, int var2);

    protected abstract int readParameterWordsWireFormat(byte[] var1, int var2);

    protected abstract int readBytesWireFormat(byte[] var1, int var2) throws SMBProtocolDecodingException;

    public int hashCode() {
        return this.mid;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerMessageBlock && ((ServerMessageBlock)obj).mid == this.mid;
    }

    public String toString() {
        String c = switch (this.command) {
            case 114 -> "SMB_COM_NEGOTIATE";
            case 115 -> "SMB_COM_SESSION_SETUP_ANDX";
            case 117 -> "SMB_COM_TREE_CONNECT_ANDX";
            case 8 -> "SMB_COM_QUERY_INFORMATION";
            case 16 -> "SMB_COM_CHECK_DIRECTORY";
            case 37 -> "SMB_COM_TRANSACTION";
            case 50 -> "SMB_COM_TRANSACTION2";
            case 38 -> "SMB_COM_TRANSACTION_SECONDARY";
            case 52 -> "SMB_COM_FIND_CLOSE2";
            case 113 -> "SMB_COM_TREE_DISCONNECT";
            case 116 -> "SMB_COM_LOGOFF_ANDX";
            case 43 -> "SMB_COM_ECHO";
            case 42 -> "SMB_COM_MOVE";
            case 7 -> "SMB_COM_RENAME";
            case 6 -> "SMB_COM_DELETE";
            case 1 -> "SMB_COM_DELETE_DIRECTORY";
            case -94 -> "SMB_COM_NT_CREATE_ANDX";
            case 45 -> "SMB_COM_OPEN_ANDX";
            case 46 -> "SMB_COM_READ_ANDX";
            case 4 -> "SMB_COM_CLOSE";
            case 47 -> "SMB_COM_WRITE_ANDX";
            case 0 -> "SMB_COM_CREATE_DIRECTORY";
            case -96 -> "SMB_COM_NT_TRANSACT";
            case -95 -> "SMB_COM_NT_TRANSACT_SECONDARY";
            case 36 -> "SMB_COM_LOCKING_ANDX";
            default -> "UNKNOWN";
        };
        String str = this.errorCode == 0 ? "0" : SmbException.getMessageByCode(this.errorCode);
        return "command=" + c + ",received=" + this.received + ",errorCode=" + str + ",flags=0x" + Hexdump.toHexString(this.flags & 0xFF, 4) + ",flags2=0x" + Hexdump.toHexString(this.flags2, 4) + ",signSeq=" + this.signSeq + ",tid=" + this.tid + ",pid=" + this.pid + ",uid=" + this.uid + ",mid=" + this.mid + ",wordCount=" + this.wordCount + ",byteCount=" + this.byteCount;
    }
}

