/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.fscc;

import java.nio.charset.StandardCharsets;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.fscc.FileInformation;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class FileRenameInformation2
implements FileInformation {
    private boolean replaceIfExists;
    private String fileName;

    public FileRenameInformation2() {
    }

    public FileRenameInformation2(String name, boolean replaceIfExists) {
        this.fileName = name;
        this.replaceIfExists = replaceIfExists;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.replaceIfExists = buffer[bufferIndex] != 0;
        bufferIndex += 8;
        int nameLen = SMBUtil.readInt4(buffer, bufferIndex += 8);
        byte[] nameBytes = new byte[nameLen];
        System.arraycopy(buffer, bufferIndex += 4, nameBytes, 0, nameBytes.length);
        this.fileName = new String(nameBytes, StandardCharsets.UTF_16LE);
        return (bufferIndex += nameLen) - start;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex] = (byte)(this.replaceIfExists ? 1 : 0);
        dstIndex += 8;
        byte[] nameBytes = this.fileName.getBytes(StandardCharsets.UTF_16LE);
        SMBUtil.writeInt4(nameBytes.length, dst, dstIndex += 8);
        System.arraycopy(nameBytes, 0, dst, dstIndex += 4, nameBytes.length);
        return (dstIndex += nameBytes.length) - start;
    }

    @Override
    public int size() {
        return 20 + 2 * this.fileName.length();
    }

    @Override
    public byte getFileInformationLevel() {
        return 10;
    }
}

