/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.fscc;

import java.util.Date;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.fscc.BasicFileInformation;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class FileBasicInfo
implements BasicFileInformation {
    private long createTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private int attributes;

    public FileBasicInfo() {
    }

    public FileBasicInfo(long create, long lastAccess, long lastWrite, long change, int attributes) {
        this.createTime = create;
        this.lastAccessTime = lastAccess;
        this.lastWriteTime = lastWrite;
        this.changeTime = change;
        this.attributes = attributes;
    }

    @Override
    public byte getFileInformationLevel() {
        return 4;
    }

    @Override
    public int getAttributes() {
        return this.attributes;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.createTime = SMBUtil.readTime(buffer, bufferIndex);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.attributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        return (bufferIndex += 4) - start;
    }

    @Override
    public int size() {
        return 40;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeTime(this.createTime, dst, dstIndex);
        SMBUtil.writeTime(this.lastAccessTime, dst, dstIndex += 8);
        SMBUtil.writeTime(this.lastWriteTime, dst, dstIndex += 8);
        SMBUtil.writeTime(this.changeTime, dst, dstIndex += 8);
        SMBUtil.writeInt4(this.attributes, dst, dstIndex += 8);
        dstIndex += 4;
        return (dstIndex += 4) - start;
    }

    public String toString() {
        return "SmbQueryFileBasicInfo[createTime=" + String.valueOf(new Date(this.createTime)) + ",lastAccessTime=" + String.valueOf(new Date(this.lastAccessTime)) + ",lastWriteTime=" + String.valueOf(new Date(this.lastWriteTime)) + ",changeTime=" + String.valueOf(new Date(this.changeTime)) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]";
    }
}

