/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import java.util.List;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.FileNotifyInformation;
import org.codelibs.jcifs.smb.SmbWatchHandle;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbFileHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbUnsupportedOperationException;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.NotifyResponse;
import org.codelibs.jcifs.smb.internal.smb1.trans.nt.NtTransNotifyChange;
import org.codelibs.jcifs.smb.internal.smb1.trans.nt.NtTransNotifyChangeResponse;
import org.codelibs.jcifs.smb.internal.smb2.notify.Smb2ChangeNotifyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbWatchHandleImpl
implements SmbWatchHandle {
    private static final Logger log = LoggerFactory.getLogger(SmbWatchHandleImpl.class);
    private final SmbFileHandleImpl handle;
    private final int filter;
    private final boolean recursive;

    public SmbWatchHandleImpl(SmbFileHandleImpl fh, int filter, boolean recursive) {
        this.handle = fh;
        this.filter = filter;
        this.recursive = recursive;
    }

    @Override
    public List<FileNotifyInformation> watch() throws CIFSException {
        NotifyResponse resp;
        SmbTreeHandleImpl th;
        block19: {
            CommonServerMessageBlockRequest req;
            if (!this.handle.isValid()) {
                throw new SmbException("Watch was broken by tree disconnect");
            }
            th = this.handle.getTree();
            resp = null;
            if (th.isSMB2()) {
                Smb2ChangeNotifyRequest r = new Smb2ChangeNotifyRequest(th.getConfig(), this.handle.getFileId());
                r.setCompletionFilter(this.filter);
                r.setNotifyFlags(this.recursive ? 1 : 0);
                req = r;
            } else {
                if (!th.hasCapability(16)) {
                    throw new SmbUnsupportedOperationException("Not supported without CAP_NT_SMBS");
                }
                req = new NtTransNotifyChange(th.getConfig(), this.handle.getFid(), this.filter, this.recursive);
                resp = new NtTransNotifyChangeResponse(th.getConfig());
            }
            if (log.isTraceEnabled()) {
                log.trace("Sending NtTransNotifyChange for " + String.valueOf(this.handle));
            }
            try {
                resp = th.send(req, resp, RequestParam.NO_TIMEOUT, RequestParam.NO_RETRY);
            }
            catch (SmbException e) {
                if (e.getNtStatus() == -1073741536) {
                    log.debug("Request was cancelled", (Throwable)e);
                    List<FileNotifyInformation> list = null;
                    if (th != null) {
                        th.close();
                    }
                    return list;
                }
                throw e;
            }
            if (!log.isTraceEnabled()) break block19;
            log.trace("Returned from NtTransNotifyChange " + resp.getErrorCode());
        }
        if (!resp.isReceived()) {
            throw new CIFSException("Did not receive response");
        }
        if (resp.getErrorCode() == 267) {
            this.handle.markClosed();
        }
        if (resp.getErrorCode() == 268) {
            resp.getNotifyInformation().clear();
        }
        List<FileNotifyInformation> list = resp.getNotifyInformation();
        return list;
        finally {
            if (th != null) {
                try {
                    th.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public List<FileNotifyInformation> call() throws CIFSException {
        return this.watch();
    }

    @Override
    public void close() throws CIFSException {
        if (this.handle.isValid()) {
            this.handle.close(0L);
        }
    }
}

