/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.CloseableIterator;
import org.codelibs.jcifs.smb.ResourceNameFilter;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.impl.FileEntry;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirFileEntryEnumIteratorBase
implements CloseableIterator<FileEntry> {
    private static final Logger log = LoggerFactory.getLogger(DirFileEntryEnumIteratorBase.class);
    private final SmbTreeHandleImpl treeHandle;
    private final ResourceNameFilter nameFilter;
    private final SmbResource parent;
    private final String wildcard;
    private final int searchAttributes;
    private FileEntry next;
    private int ridx;
    private boolean closed = false;

    public DirFileEntryEnumIteratorBase(SmbTreeHandleImpl th, SmbResource parent, String wildcard, ResourceNameFilter filter, int searchAttributes) throws CIFSException {
        this.parent = parent;
        this.wildcard = wildcard;
        this.nameFilter = filter;
        this.searchAttributes = searchAttributes;
        this.treeHandle = th.acquire();
        try {
            this.next = this.open();
            if (this.next == null) {
                this.doClose();
            }
        }
        catch (Exception e) {
            this.doClose();
            throw e;
        }
    }

    public final SmbTreeHandleImpl getTreeHandle() {
        return this.treeHandle;
    }

    public final int getSearchAttributes() {
        return this.searchAttributes;
    }

    public final String getWildcard() {
        return this.wildcard;
    }

    public final SmbResource getParent() {
        return this.parent;
    }

    private final boolean filter(FileEntry fe) {
        int h;
        String name = fe.getName();
        if (name.length() < 3 && ((h = name.hashCode()) == SmbFile.HASH_DOT || h == SmbFile.HASH_DOT_DOT) && (name.equals(".") || name.equals(".."))) {
            return false;
        }
        if (this.nameFilter == null) {
            return true;
        }
        try {
            return this.nameFilter.accept(this.parent, name);
        }
        catch (CIFSException e) {
            log.error("Failed to apply name filter", (Throwable)e);
            return false;
        }
    }

    protected final FileEntry advance(boolean last) throws CIFSException {
        FileEntry[] results = this.getResults();
        while (this.ridx < results.length) {
            FileEntry itm = results[this.ridx];
            ++this.ridx;
            if (!this.filter(itm)) continue;
            return itm;
        }
        if (!last && !this.isDone()) {
            if (!this.fetchMore()) {
                this.doClose();
                return null;
            }
            this.ridx = 0;
            return this.advance(true);
        }
        return null;
    }

    protected abstract FileEntry open() throws CIFSException;

    protected abstract boolean isDone();

    protected abstract boolean fetchMore() throws CIFSException;

    protected abstract FileEntry[] getResults();

    protected synchronized void doClose() throws CIFSException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.doCloseInternal();
            }
            finally {
                this.next = null;
                this.treeHandle.release();
            }
        }
    }

    protected abstract void doCloseInternal() throws CIFSException;

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public FileEntry next() {
        FileEntry n = this.next;
        try {
            FileEntry ne = this.advance(false);
            if (ne == null) {
                this.doClose();
                return n;
            }
            this.next = ne;
        }
        catch (CIFSException e) {
            log.warn("Enumeration failed", (Throwable)e);
            this.next = null;
            try {
                this.doClose();
            }
            catch (CIFSException e1) {
                log.debug("Failed to close enum", (Throwable)e);
            }
        }
        return n;
    }

    @Override
    public void close() throws CIFSException {
        if (this.next != null) {
            this.doClose();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

