/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.context;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.config.PropertyConfiguration;
import org.codelibs.jcifs.smb.context.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonContext
extends BaseContext
implements CIFSContext {
    private static final Logger log = LoggerFactory.getLogger(SingletonContext.class);
    private static SingletonContext INSTANCE;

    public static final synchronized void init(Properties props) throws CIFSException {
        Properties p;
        block9: {
            if (INSTANCE != null) {
                throw new CIFSException("Singleton context is already initialized");
            }
            p = new Properties();
            try {
                String filename = System.getProperty("jcifs.properties");
                if (filename == null || filename.length() <= 1) break block9;
                try (FileInputStream in = new FileInputStream(filename);){
                    p.load(in);
                }
            }
            catch (IOException ioe) {
                log.error("Failed to load config", (Throwable)ioe);
            }
        }
        p.putAll((Map<?, ?>)System.getProperties());
        if (props != null) {
            p.putAll((Map<?, ?>)props);
        }
        INSTANCE = new SingletonContext(p);
    }

    public static final synchronized SingletonContext getInstance() {
        if (INSTANCE == null) {
            try {
                log.debug("Initializing singleton context");
                SingletonContext.init(null);
            }
            catch (CIFSException e) {
                log.error("Failed to create singleton JCIFS context", (Throwable)e);
            }
        }
        return INSTANCE;
    }

    public static void registerSmbURLHandler() {
        SingletonContext.getInstance();
        Object pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null) {
            System.setProperty("java.protocol.handler.pkgs", "org.codelibs.jcifs");
        } else if (((String)pkgs).indexOf("org.codelibs.jcifs") == -1) {
            pkgs = (String)pkgs + "|org.codelibs.jcifs";
            System.setProperty("java.protocol.handler.pkgs", (String)pkgs);
        }
    }

    private SingletonContext(Properties p) throws CIFSException {
        super(new PropertyConfiguration(p));
    }
}

