/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.context;

import java.net.MalformedURLException;
import java.net.URLStreamHandler;
import org.codelibs.jcifs.smb.BufferCache;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Credentials;
import org.codelibs.jcifs.smb.DfsResolver;
import org.codelibs.jcifs.smb.NameServiceClient;
import org.codelibs.jcifs.smb.SidResolver;
import org.codelibs.jcifs.smb.SmbPipeResource;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.SmbTransportPool;
import org.codelibs.jcifs.smb.context.AbstractCIFSContext;
import org.codelibs.jcifs.smb.impl.BufferCacheImpl;
import org.codelibs.jcifs.smb.impl.CredentialsInternal;
import org.codelibs.jcifs.smb.impl.DfsImpl;
import org.codelibs.jcifs.smb.impl.Handler;
import org.codelibs.jcifs.smb.impl.NtlmPasswordAuthenticator;
import org.codelibs.jcifs.smb.impl.SIDCacheImpl;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbNamedPipe;
import org.codelibs.jcifs.smb.impl.SmbTransportPoolImpl;
import org.codelibs.jcifs.smb.netbios.NameServiceClientImpl;

public class BaseContext
extends AbstractCIFSContext {
    private final Configuration config;
    private final DfsResolver dfs;
    private final SidResolver sidResolver;
    private final Handler urlHandler;
    private final NameServiceClient nameServiceClient;
    private final BufferCache bufferCache;
    private final SmbTransportPool transportPool;
    private final CredentialsInternal defaultCredentials;

    public BaseContext(Configuration config) {
        this.config = config;
        this.dfs = new DfsImpl(this);
        this.sidResolver = new SIDCacheImpl(this);
        this.urlHandler = new Handler(this);
        this.nameServiceClient = new NameServiceClientImpl(this);
        this.bufferCache = new BufferCacheImpl(this.config);
        this.transportPool = new SmbTransportPoolImpl();
        String defUser = config.getDefaultUsername();
        String defPassword = config.getDefaultPassword();
        String defDomain = config.getDefaultDomain();
        this.defaultCredentials = defUser != null ? new NtlmPasswordAuthenticator(defDomain, defUser, defPassword) : new NtlmPasswordAuthenticator();
    }

    @Override
    public SmbResource get(String url) throws CIFSException {
        try {
            return new SmbFile(url, (CIFSContext)this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    @Override
    public SmbPipeResource getPipe(String url, int pipeType) throws CIFSException {
        try {
            return new SmbNamedPipe(url, pipeType, this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    @Override
    public SmbTransportPool getTransportPool() {
        return this.transportPool;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public DfsResolver getDfs() {
        return this.dfs;
    }

    @Override
    public NameServiceClient getNameServiceClient() {
        return this.nameServiceClient;
    }

    @Override
    public BufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public URLStreamHandler getUrlHandler() {
        return this.urlHandler;
    }

    @Override
    public SidResolver getSIDResolver() {
        return this.sidResolver;
    }

    @Override
    protected Credentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    @Override
    public boolean close() throws CIFSException {
        boolean inUse = super.close();
        return inUse |= this.transportPool.close();
    }
}

