/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import jcifs.pac.PACDecodingException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DLSequence;

public final class ASN1Util {
    private ASN1Util() {
    }

    public static <T> T as(Class<T> type, Object object) throws PACDecodingException {
        if (!type.isInstance(object)) {
            throw new PACDecodingException("Incompatible object types " + type + " " + object.getClass());
        }
        return type.cast(object);
    }

    public static <T> T as(Class<T> type, Enumeration<?> enumeration) throws PACDecodingException {
        return ASN1Util.as(type, enumeration.nextElement());
    }

    public static <T extends ASN1Primitive> T as(Class<T> type, ASN1InputStream stream) throws PACDecodingException, IOException {
        return (T)((ASN1Primitive)ASN1Util.as(type, stream.readObject()));
    }

    public static <T extends ASN1Primitive> T as(Class<T> type, ASN1TaggedObject tagged) throws PACDecodingException {
        return (T)((ASN1Primitive)ASN1Util.as(type, tagged.getBaseObject()));
    }

    public static <T extends ASN1Primitive> T as(Class<T> type, DLSequence sequence, int index) throws PACDecodingException {
        return ASN1Util.as(type, sequence, index);
    }

    public static <T extends ASN1Primitive> T as(Class<T> type, ASN1Sequence sequence, int index) throws PACDecodingException {
        return (T)((ASN1Primitive)ASN1Util.as(type, sequence.getObjectAt(index)));
    }

    public static byte[] readUnparsedTagged(int expectTag, int limit, ASN1InputStream in) throws IOException {
        int ftag = in.read();
        int tag = ASN1Util.readTagNumber((InputStream)in, ftag);
        if (tag != expectTag) {
            throw new IOException("Unexpected tag " + tag);
        }
        int length = ASN1Util.readLength((InputStream)in, limit, false);
        byte[] content = new byte[length];
        in.read(content);
        return content;
    }

    static int readTagNumber(InputStream s, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            int b = s.read();
            if (b < 31) {
                if (b < 0) {
                    throw new EOFException("EOF found inside tag value.");
                }
                throw new IOException("corrupted stream - high tag number < 31 found");
            }
            tagNo = b & 0x7F;
            if (0 == tagNo) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while ((b & 0x80) != 0) {
                if (tagNo >>> 24 != 0) {
                    throw new IOException("Tag number more than 31 bits");
                }
                tagNo <<= 7;
                b = s.read();
                if (b < 0) {
                    throw new EOFException("EOF found inside tag value.");
                }
                tagNo |= b & 0x7F;
            }
        }
        return tagNo;
    }

    static int readLength(InputStream s, int limit, boolean isParsing) throws IOException {
        int length = s.read();
        if (0 == length >>> 7) {
            return length;
        }
        if (128 == length) {
            return -1;
        }
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (255 == length) {
            throw new IOException("invalid long form definite-length 0xFF");
        }
        int octetsCount = length & 0x7F;
        int octetsPos = 0;
        length = 0;
        do {
            int octet;
            if ((octet = s.read()) < 0) {
                throw new EOFException("EOF found reading length");
            }
            if (length >>> 23 != 0) {
                throw new IOException("long form definite-length more than 31 bits");
            }
            length = (length << 8) + octet;
        } while (++octetsPos < octetsCount);
        if (length >= limit && !isParsing) {
            throw new IOException("corrupted stream - out of bounds length found: " + length + " >= " + limit);
        }
        return length;
    }
}

