/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.MalformedURLException;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.SmbResource;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.fscc.FileBasicInfo;
import jcifs.internal.smb1.com.SmbComSetInformation;
import jcifs.internal.smb1.com.SmbComSetInformationResponse;
import jcifs.internal.smb1.trans2.Trans2SetFileInformation;
import jcifs.internal.smb1.trans2.Trans2SetFileInformationResponse;
import jcifs.internal.smb2.info.Smb2SetInfoRequest;
import jcifs.internal.smb2.ioctl.Smb2IoctlRequest;
import jcifs.internal.smb2.ioctl.Smb2IoctlResponse;
import jcifs.internal.smb2.ioctl.SrvCopyChunkCopyResponse;
import jcifs.internal.smb2.ioctl.SrvCopychunk;
import jcifs.internal.smb2.ioctl.SrvCopychunkCopy;
import jcifs.internal.smb2.ioctl.SrvRequestResumeKeyResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbEnumerationUtil;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.smb.WriterThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbCopyUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbCopyUtil.class);

    private SmbCopyUtil() {
    }

    static SmbFileHandleImpl openCopyTargetFile(SmbFile dest, int attrs, boolean alsoRead) throws CIFSException {
        try {
            return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
        }
        catch (SmbAuthException sae) {
            log.trace("copyTo0", (Throwable)sae);
            int dattrs = dest.getAttributes();
            if ((dattrs & 1) != 0) {
                dest.setPathInformation(dattrs & 0xFFFFFFFE, 0L, 0L, 0L);
                return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
            }
            throw sae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws SmbException {
        if (sh.isSMB2() && dh.isSMB2() && sh.isSameTree(dh)) {
            try {
                SmbCopyUtil.serverSideCopy(src, dest, sh, dh, false);
                return;
            }
            catch (SmbUnsupportedOperationException e) {
                log.debug("Server side copy not supported, falling back to normal copying", (Throwable)e);
            }
            catch (CIFSException e) {
                log.warn("Server side copy failed", (Throwable)e);
                throw SmbException.wrap(e);
            }
        }
        try (SmbFileHandleImpl sfd = src.openUnshared(0, 1, 1, 128, 0);
             SmbFileInputStream fis = new SmbFileInputStream(src, sh, sfd);){
            int attrs = src.getAttributes();
            try (SmbFileHandleImpl dfd = SmbCopyUtil.openCopyTargetFile(dest, attrs, false);
                 SmbFileOutputStream fos = new SmbFileOutputStream(dest, dh, dfd, 82, 258, 0);){
                long mtime = src.lastModified();
                long ctime = src.createTime();
                long atime = src.lastAccess();
                int i = 0;
                long off = 0L;
                while (true) {
                    int read = fis.read(b[i]);
                    WriterThread writerThread = w;
                    synchronized (writerThread) {
                        w.checkException();
                        while (!w.isReady()) {
                            try {
                                w.wait();
                            }
                            catch (InterruptedException ie) {
                                throw new SmbException(dest.getURL().toString(), (Throwable)ie);
                            }
                        }
                        w.checkException();
                        if (read <= 0) {
                            break;
                        }
                        w.write(b[i], read, fos);
                    }
                    i = i == 1 ? 0 : 1;
                    off += (long)read;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Copied a total of %d bytes", off));
                }
                if (dh.isSMB2()) {
                    Smb2SetInfoRequest req = new Smb2SetInfoRequest(dh.getConfig(), dfd.getFileId());
                    req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs));
                    dh.send(req, new RequestParam[0]);
                } else if (dh.hasCapability(16)) {
                    dh.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(dh.getConfig(), dfd.getFid(), attrs, ctime, mtime, atime), new Trans2SetFileInformationResponse(dh.getConfig()), new RequestParam[0]);
                } else {
                    dh.send((CommonServerMessageBlockRequest)new SmbComSetInformation(dh.getConfig(), dest.getUncPath(), attrs, mtime), new SmbComSetInformationResponse(dh.getConfig()), new RequestParam[0]);
                }
            }
        }
        catch (IOException se) {
            if (!src.getContext().getConfig().isIgnoreCopyToException()) {
                throw new SmbException("Failed to copy file from [" + src.toString() + "] to [" + dest.toString() + "]", (Throwable)se);
            }
            log.warn("Copy failed", (Throwable)se);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void serverSideCopy(SmbFile src, SmbFile dest, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh, boolean write) throws CIFSException {
        SmbCopyUtil.log.debug("Trying server side copy");
        dfd = null;
        try {
            sfd = src.openUnshared(0, 1, 1, 128, 0);
            if (sfd.getInitialSize() == 0L) {
                edfd = SmbCopyUtil.openCopyTargetFile(dest, src.getAttributes(), write == false);
                if (edfd != null) {
                    edfd.close();
                }
                if (sfd == null) return;
            }
            ** GOTO lbl23
            {
                catch (Throwable var10_9) {
                    if (sfd == null) throw var10_9;
                    try {
                        sfd.close();
                        throw var10_9;
                    }
                    catch (Throwable var11_11) {
                        var10_9.addSuppressed(var11_11);
                    }
                    throw var10_9;
                }
                sfd.close();
                return;
lbl23:
                // 1 sources

                resumeReq = new Smb2IoctlRequest(sh.getConfig(), 1310840, sfd.getFileId());
                resumeReq.setFlags(1);
            }
        }
        catch (SmbUnsupportedOperationException e) {
            throw e;
            catch (IOException se) {
                throw new CIFSException("Server side copy failed", se);
            }
        }
        resumeResp = sh.send(resumeReq, new RequestParam[0]);
        rkresp = resumeResp.getOutputData(SrvRequestResumeKeyResponse.class);
        size = sfd.getInitialSize();
        resumeKey = rkresp.getResumeKey();
        maxChunks = 256;
        maxChunkSize = 0x100000;
        byteLimit = 0x1000000;
        retry = false;
        ooff = 0L;
        while (ooff < size) {
            wsize = size - ooff;
            if (wsize > (long)byteLimit) {
                wsize = byteLimit;
            }
            if ((chunks = (int)(wsize / (long)maxChunkSize)) + 1 > maxChunks) {
                chunks = maxChunks;
                lastChunkSize = maxChunkSize;
            } else {
                lastChunkSize = (int)(wsize % (long)maxChunkSize);
                if (lastChunkSize != 0) {
                    ++chunks;
                } else {
                    lastChunkSize = maxChunkSize;
                }
            }
            chunkInfo = new SrvCopychunk[chunks];
            ioff = 0L;
            for (i = 0; i < chunks; ioff += (long)maxChunkSize, ++i) {
                absoff = ooff + ioff;
                csize = i == chunks - 1 ? lastChunkSize : maxChunkSize;
                chunkInfo[i] = new SrvCopychunk(absoff, absoff, csize);
            }
            if (dfd == null || !dfd.isValid()) {
                dfd = SmbCopyUtil.openCopyTargetFile(dest, src.getAttributes(), write == false);
            }
            copy = new Smb2IoctlRequest(sh.getConfig(), write != false ? 1343730 : 1327346, dfd.getFileId());
            copy.setFlags(1);
            copy.setInputData(new SrvCopychunkCopy(resumeKey, chunkInfo));
            try {
                r = dh.send(copy, new RequestParam[]{RequestParam.NO_RETRY}).getOutputData(SrvCopyChunkCopyResponse.class);
                if (SmbCopyUtil.log.isDebugEnabled()) {
                    SmbCopyUtil.log.debug(String.format("Wrote %d bytes (%d chunks, last partial write %d)", new Object[]{r.getTotalBytesWritten(), r.getChunksWritten(), r.getChunkBytesWritten()}));
                }
                ooff += (long)r.getTotalBytesWritten();
            }
            catch (SmbException e) {
                response = (Smb2IoctlResponse)copy.getResponse();
                if (retry != false) throw e;
                if (response.isReceived() == false) throw e;
                if (response.isError() != false) throw e;
                if (response.getStatus() != -1073741811) throw e;
                retry = true;
                outputData = response.getOutputData(SrvCopyChunkCopyResponse.class);
                maxChunks = outputData.getChunksWritten();
                maxChunkSize = outputData.getChunkBytesWritten();
                byteLimit = outputData.getTotalBytesWritten();
            }
        }
        if (sfd != null) {
            sfd.close();
        }
        if (dfd == null) return;
        dfd.close();
        return;
        finally {
            if (dfd != null) {
                dfd.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyDir(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws CIFSException {
        block25: {
            String path = dest.getLocator().getUNCPath();
            if (path.length() > 1) {
                try {
                    dest.mkdir();
                    if (dh.hasCapability(16)) {
                        dest.setPathInformation(src.getAttributes(), src.createTime(), src.lastModified(), src.lastAccess());
                    } else {
                        dest.setPathInformation(src.getAttributes(), 0L, src.lastModified(), 0L);
                    }
                }
                catch (SmbUnsupportedOperationException e) {
                    if (!src.getContext().getConfig().isIgnoreCopyToException()) throw e;
                    log.warn("Failed to set file attributes on " + path, (Throwable)e);
                }
                catch (SmbException se) {
                    log.trace("copyTo0", (Throwable)se);
                    if (se.getNtStatus() == -1073741790 || se.getNtStatus() == -1073741771) break block25;
                    throw se;
                }
            }
        }
        try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(src, "*", 22, null, null);){
            while (it.hasNext()) {
                SmbResource r = (SmbResource)it.next();
                try (SmbFile ndest = new SmbFile(dest, r.getLocator().getName(), true, r.getLocator().getType(), r.getAttributes(), r.createTime(), r.lastModified(), r.lastAccess(), r.length());){
                    if (!(r instanceof SmbFile)) continue;
                    ((SmbFile)r).copyRecursive(ndest, b, bsize, w, sh, dh);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
            return;
        }
        catch (MalformedURLException mue) {
            throw new SmbException(src.getURL().toString(), (Throwable)mue);
        }
    }
}

