/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.DfsReferralData;
import jcifs.DialectVersion;
import jcifs.SmbConstants;
import jcifs.SmbTransport;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.Request;
import jcifs.internal.RequestWithPath;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.SMBSigningDigest;
import jcifs.internal.SmbNegotiation;
import jcifs.internal.SmbNegotiationResponse;
import jcifs.internal.dfs.DfsReferralDataImpl;
import jcifs.internal.smb1.AndXServerMessageBlock;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.smb1.com.SmbComLockingAndX;
import jcifs.internal.smb1.com.SmbComNegotiate;
import jcifs.internal.smb1.com.SmbComNegotiateResponse;
import jcifs.internal.smb1.com.SmbComReadAndXResponse;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.smb1.trans.SmbComTransactionResponse;
import jcifs.internal.smb2.ServerMessageBlock2;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.io.Smb2ReadResponse;
import jcifs.internal.smb2.ioctl.Smb2IoctlResponse;
import jcifs.internal.smb2.lock.Smb2OplockBreakNotification;
import jcifs.internal.smb2.nego.Smb2NegotiateRequest;
import jcifs.internal.smb2.nego.Smb2NegotiateResponse;
import jcifs.netbios.Name;
import jcifs.netbios.NbtException;
import jcifs.netbios.SessionRequestPacket;
import jcifs.smb.DfsReferral;
import jcifs.smb.RequestParam;
import jcifs.smb.SMBSignatureValidationException;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTransportInternal;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.util.Crypto;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import jcifs.util.transport.Response;
import jcifs.util.transport.Transport;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTransportImpl
extends Transport
implements SmbTransportInternal,
SmbConstants {
    private static Logger log = LoggerFactory.getLogger(SmbTransportImpl.class);
    private boolean smb2 = false;
    private InetAddress localAddr;
    private int localPort;
    private Address address;
    private Socket socket;
    private int port;
    private final AtomicLong mid = new AtomicLong();
    private OutputStream out;
    private InputStream in;
    private final byte[] sbuf = new byte[1024];
    private long sessionExpiration;
    private final List<SmbSessionImpl> sessions = new LinkedList<SmbSessionImpl>();
    private String tconHostName = null;
    private final CIFSContext transportContext;
    private final boolean signingEnforced;
    private SmbNegotiationResponse negotiated;
    private SMBSigningDigest digest;
    private final Semaphore credits = new Semaphore(1, true);
    private final int desiredCredits = 512;
    private byte[] preauthIntegrityHash = new byte[64];

    SmbTransportImpl(CIFSContext tc, Address address, int port, InetAddress localAddr, int localPort, boolean forceSigning) {
        this.transportContext = tc;
        this.signingEnforced = forceSigning || this.getContext().getConfig().isSigningEnforced();
        this.sessionExpiration = System.currentTimeMillis() + (long)tc.getConfig().getSessionTimeout();
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
    }

    @Override
    protected int getResponseTimeout(jcifs.util.transport.Request req) {
        Integer overrideTimeout;
        if (req instanceof CommonServerMessageBlockRequest && (overrideTimeout = ((CommonServerMessageBlockRequest)req).getOverrideTimeout()) != null) {
            return overrideTimeout;
        }
        return this.getContext().getConfig().getResponseTimeout();
    }

    @Override
    public Address getRemoteAddress() {
        return this.address;
    }

    @Override
    public String getRemoteHostName() {
        return this.tconHostName;
    }

    public int getNumSessions() {
        return this.sessions.size();
    }

    @Override
    public int getInflightRequests() {
        return this.response_map.size();
    }

    @Override
    public boolean isDisconnected() {
        Socket s = this.socket;
        return super.isDisconnected() || s == null || s.isClosed();
    }

    @Override
    public boolean isFailed() {
        Socket s = this.socket;
        return super.isFailed() || s == null || s.isClosed();
    }

    @Override
    public boolean hasCapability(int cap) throws SmbException {
        return this.getNegotiateResponse().haveCapabilitiy(cap);
    }

    SmbNegotiationResponse getNegotiateResponse() throws SmbException {
        try {
            if (this.negotiated == null) {
                this.connect(this.transportContext.getConfig().getResponseTimeout());
            }
        }
        catch (IOException ioe) {
            throw new SmbException(ioe.getMessage(), (Throwable)ioe);
        }
        SmbNegotiationResponse r = this.negotiated;
        if (r == null) {
            throw new SmbException("Connection did not complete, failed to get negotiation response");
        }
        return r;
    }

    @Override
    public boolean isSMB2() throws SmbException {
        return this.smb2 || this.getNegotiateResponse() instanceof Smb2NegotiateResponse;
    }

    public void setDigest(SMBSigningDigest digest) {
        this.digest = digest;
    }

    public SMBSigningDigest getDigest() {
        return this.digest;
    }

    @Override
    public CIFSContext getContext() {
        return this.transportContext;
    }

    @Override
    public SmbTransportImpl acquire() {
        return (SmbTransportImpl)super.acquire();
    }

    @Override
    public byte[] getServerEncryptionKey() {
        if (this.negotiated == null) {
            return null;
        }
        if (this.negotiated instanceof SmbComNegotiateResponse) {
            return ((SmbComNegotiateResponse)this.negotiated).getServerData().encryptionKey;
        }
        return null;
    }

    @Override
    public boolean isSigningOptional() throws SmbException {
        if (this.signingEnforced) {
            return false;
        }
        SmbNegotiationResponse nego = this.getNegotiateResponse();
        return nego.isSigningNegotiated() && !nego.isSigningRequired();
    }

    @Override
    public boolean isSigningEnforced() throws SmbException {
        if (this.signingEnforced) {
            return true;
        }
        return this.getNegotiateResponse().isSigningRequired();
    }

    @Override
    public <T extends SmbTransport> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    @Override
    public SmbSessionImpl getSmbSession(CIFSContext tf) {
        return this.getSmbSession(tf, null, null);
    }

    @Override
    public synchronized SmbSessionImpl getSmbSession(CIFSContext tf, String targetHost, String targetDomain) {
        long now;
        SmbSessionImpl ssn;
        if (log.isTraceEnabled()) {
            log.trace("Currently " + this.sessions.size() + " session(s) active for " + this);
        }
        if (targetHost != null) {
            targetHost = targetHost.toLowerCase(Locale.ROOT);
        }
        if (targetDomain != null) {
            targetDomain = targetDomain.toUpperCase(Locale.ROOT);
        }
        ListIterator<SmbSessionImpl> iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            ssn = iter.next();
            if (ssn.matches(tf, targetHost, targetDomain)) {
                if (log.isTraceEnabled()) {
                    log.trace("Reusing existing session " + ssn);
                }
                return ssn.acquire();
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Existing session " + ssn + " does not match " + tf.getCredentials());
        }
        if (tf.getConfig().getSessionTimeout() > 0 && this.sessionExpiration < (now = System.currentTimeMillis())) {
            this.sessionExpiration = now + (long)tf.getConfig().getSessionTimeout();
            iter = this.sessions.listIterator();
            while (iter.hasNext()) {
                ssn = iter.next();
                if (ssn.getExpiration() == null || ssn.getExpiration() >= now || ssn.isInUse()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Closing session after timeout " + ssn);
                }
                ssn.logoff(false, false);
            }
        }
        ssn = new SmbSessionImpl(tf, targetHost, targetDomain, this);
        if (log.isDebugEnabled()) {
            log.debug("Establishing new session " + ssn + " on " + this.name);
        }
        this.sessions.add(ssn);
        return ssn;
    }

    boolean matches(Address addr, int prt, InetAddress laddr, int lprt, String hostName) {
        if (this.state == 5 || this.state == 6) {
            return false;
        }
        if (hostName == null) {
            hostName = addr.getHostName();
        }
        return (this.tconHostName == null || hostName.equalsIgnoreCase(this.tconHostName)) && addr.equals(this.address) && (prt == 0 || prt == this.port || prt == 445 && this.port == 139) && (laddr == this.localAddr || laddr != null && laddr.equals(this.localAddr)) && lprt == this.localPort;
    }

    void ssn139() throws IOException {
        CIFSContext tc = this.transportContext;
        Name calledName = new Name(tc.getConfig(), this.address.firstCalledName(), 32, null);
        do {
            this.socket = new Socket();
            if (this.localAddr != null) {
                this.socket.bind(new InetSocketAddress(this.localAddr, this.localPort));
            }
            this.socket.connect(new InetSocketAddress(this.address.getHostAddress(), 139), tc.getConfig().getConnTimeout());
            this.socket.setSoTimeout(tc.getConfig().getSoTimeout());
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            SessionRequestPacket ssp = new SessionRequestPacket(tc.getConfig(), calledName, tc.getNameServiceClient().getLocalName());
            this.out.write(this.sbuf, 0, ssp.writeWireFormat(this.sbuf, 0));
            if (SmbTransportImpl.readn(this.in, this.sbuf, 0, 4) < 4) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    log.debug("Failed to close socket", (Throwable)ioe);
                }
                throw new SmbException("EOF during NetBIOS session request");
            }
            block1 : switch (this.sbuf[0] & 0xFF) {
                case 130: {
                    if (log.isDebugEnabled()) {
                        log.debug("session established ok with " + this.address);
                    }
                    return;
                }
                case 131: {
                    int errorCode = this.in.read() & 0xFF;
                    switch (errorCode) {
                        case 128: 
                        case 130: {
                            this.socket.close();
                            break block1;
                        }
                    }
                    this.disconnect(true);
                    throw new NbtException(2, errorCode);
                }
                case -1: {
                    this.disconnect(true);
                    throw new NbtException(2, -1);
                }
                default: {
                    this.disconnect(true);
                    throw new NbtException(2, 0);
                }
            }
        } while ((calledName.name = this.address.nextCalledName(tc)) != null);
        throw new IOException("Failed to establish session with " + this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbNegotiation negotiate(int prt) throws IOException {
        Object object = this.inLock;
        synchronized (object) {
            if (prt == 139) {
                this.ssn139();
            } else {
                if (prt == 0) {
                    prt = 445;
                }
                this.socket = new Socket();
                if (this.localAddr != null) {
                    this.socket.bind(new InetSocketAddress(this.localAddr, this.localPort));
                }
                this.socket.connect(new InetSocketAddress(this.address.getHostAddress(), prt), this.transportContext.getConfig().getConnTimeout());
                this.socket.setSoTimeout(this.transportContext.getConfig().getSoTimeout());
                this.out = this.socket.getOutputStream();
                this.in = this.socket.getInputStream();
            }
            if (this.credits.drainPermits() == 0) {
                log.debug("It appears we previously lost some credits");
            }
            if (this.smb2 || this.getContext().getConfig().isUseSMB2OnlyNegotiation()) {
                log.debug("Using SMB2 only negotiation");
                return this.negotiate2(null);
            }
            SmbComNegotiate comNeg = new SmbComNegotiate(this.getContext().getConfig(), this.signingEnforced);
            int n = this.negotiateWrite(comNeg, true);
            this.negotiatePeek();
            SmbComNegotiateResponse resp = null;
            if (!this.smb2) {
                if (this.getContext().getConfig().getMinimumVersion().isSMB2()) {
                    throw new CIFSException("Server does not support SMB2");
                }
                resp = new SmbComNegotiateResponse(this.getContext());
                resp.decode(this.sbuf, 4);
                resp.received();
                if (log.isTraceEnabled()) {
                    log.trace(((Object)resp).toString());
                    log.trace(Hexdump.toHexString(this.sbuf, 4, n));
                }
            } else {
                Smb2NegotiateResponse r = new Smb2NegotiateResponse(this.getContext().getConfig());
                r.decode(this.sbuf, 4);
                r.received();
                if (r.getDialectRevision() == 767) {
                    return this.negotiate2(r);
                }
                if (r.getDialectRevision() != 514) {
                    throw new CIFSException("Server returned invalid dialect verison in multi protocol negotiation");
                }
                int permits = r.getInitialCredits();
                if (permits > 0) {
                    this.credits.release(permits);
                }
                Arrays.fill(this.sbuf, (byte)0);
                return new SmbNegotiation(new Smb2NegotiateRequest(this.getContext().getConfig(), this.signingEnforced ? 2 : 1), r, null, null);
            }
            int permits = resp.getInitialCredits();
            if (permits > 0) {
                this.credits.release(permits);
            }
            Arrays.fill(this.sbuf, (byte)0);
            return new SmbNegotiation(comNeg, resp, null, null);
        }
    }

    private int negotiateWrite(CommonServerMessageBlockRequest req, boolean setmid) throws IOException {
        if (setmid) {
            this.makeKey(req);
        } else {
            req.setMid(0L);
            this.mid.set(1L);
        }
        int n = req.encode(this.sbuf, 4);
        Encdec.enc_uint32be(n & 0xFFFF, this.sbuf, 0);
        if (log.isTraceEnabled()) {
            log.trace(req.toString());
            log.trace(Hexdump.toHexString(this.sbuf, 4, n));
        }
        this.out.write(this.sbuf, 0, 4 + n);
        this.out.flush();
        log.trace("Wrote negotiate request");
        return n;
    }

    private void negotiatePeek() throws SocketException, IOException {
        try {
            this.socket.setSoTimeout(this.transportContext.getConfig().getConnTimeout());
            if (this.peekKey() == null) {
                throw new IOException("transport closed in negotiate");
            }
        }
        finally {
            this.socket.setSoTimeout(this.transportContext.getConfig().getSoTimeout());
        }
        int size = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
        if (size < 33 || 4 + size > this.sbuf.length) {
            throw new IOException("Invalid payload size: " + size);
        }
        int hdrSize = this.smb2 ? 64 : 32;
        SmbTransportImpl.readn(this.in, this.sbuf, 4 + hdrSize, size - hdrSize);
        log.trace("Read negotiate response");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbNegotiation negotiate2(Smb2NegotiateResponse first) throws IOException, SocketException {
        int grantedCredits;
        SmbNegotiation smbNegotiation;
        int size = 0;
        int securityMode = this.getRequestSecurityMode(first);
        Smb2NegotiateRequest smb2neg = new Smb2NegotiateRequest(this.getContext().getConfig(), securityMode);
        ServerMessageBlock2Response r = null;
        byte[] negoReqBuffer = null;
        byte[] negoRespBuffer = null;
        try {
            smb2neg.setRequestCredits(Math.max(1, this.desiredCredits - this.credits.availablePermits()));
            int reqLen = this.negotiateWrite(smb2neg, first != null);
            boolean doPreauth = this.getContext().getConfig().getMaximumVersion().atLeast(DialectVersion.SMB311);
            if (doPreauth) {
                negoReqBuffer = new byte[reqLen];
                System.arraycopy(this.sbuf, 4, negoReqBuffer, 0, reqLen);
            }
            this.negotiatePeek();
            r = (Smb2NegotiateResponse)smb2neg.initResponse(this.getContext());
            int respLen = r.decode(this.sbuf, 4);
            r.received();
            if (doPreauth) {
                negoRespBuffer = new byte[respLen];
                System.arraycopy(this.sbuf, 4, negoRespBuffer, 0, respLen);
            } else {
                negoReqBuffer = null;
            }
            if (log.isTraceEnabled()) {
                log.trace(((Smb2NegotiateResponse)r).toString());
                log.trace(Hexdump.toHexString(this.sbuf, 4, size));
            }
            smbNegotiation = new SmbNegotiation(smb2neg, (SmbNegotiationResponse)((Object)r), negoReqBuffer, negoRespBuffer);
            int n = grantedCredits = r != null ? r.getGrantedCredits() : 0;
        }
        catch (Throwable throwable) {
            int grantedCredits2;
            int n = grantedCredits2 = r != null ? r.getGrantedCredits() : 0;
            if (grantedCredits2 == 0) {
                grantedCredits2 = 1;
            }
            this.credits.release(grantedCredits2);
            Arrays.fill(this.sbuf, (byte)0);
            throw throwable;
        }
        if (grantedCredits == 0) {
            grantedCredits = 1;
        }
        this.credits.release(grantedCredits);
        Arrays.fill(this.sbuf, (byte)0);
        return smbNegotiation;
    }

    @Override
    public boolean ensureConnected() throws SmbException {
        try {
            return super.connect(this.transportContext.getConfig().getResponseTimeout());
        }
        catch (TransportException te) {
            throw new SmbException("Failed to connect: " + this.address, (Throwable)te);
        }
    }

    @Override
    protected void doConnect() throws IOException {
        SmbNegotiation resp;
        if (log.isDebugEnabled()) {
            log.debug("Connecting in state " + this.state + " addr " + this.address.getHostAddress());
        }
        try {
            resp = this.negotiate(this.port);
        }
        catch (IOException ce) {
            if (this.getContext().getConfig().isPort139FailoverEnabled()) {
                this.port = this.port == 0 || this.port == 445 ? 139 : 445;
                this.smb2 = false;
                this.mid.set(0L);
                resp = this.negotiate(this.port);
            }
            throw ce;
        }
        if (resp == null || resp.getResponse() == null) {
            throw new SmbException("Failed to connect.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Negotiation response on " + this.name + " :" + resp);
        }
        if (!resp.getResponse().isValid(this.getContext(), resp.getRequest())) {
            throw new SmbException("This client is not compatible with the server.");
        }
        boolean serverRequireSig = resp.getResponse().isSigningRequired();
        boolean serverEnableSig = resp.getResponse().isSigningEnabled();
        if (log.isDebugEnabled()) {
            log.debug("Signature negotiation enforced " + this.signingEnforced + " (server " + serverRequireSig + ") enabled " + this.getContext().getConfig().isSigningEnabled() + " (server " + serverEnableSig + ")");
        }
        this.tconHostName = this.address.getHostName();
        this.negotiated = resp.getResponse();
        if (resp.getResponse().getSelectedDialect().atLeast(DialectVersion.SMB311)) {
            this.updatePreauthHash(resp.getRequestRaw());
            this.updatePreauthHash(resp.getResponseRaw());
            if (log.isDebugEnabled()) {
                log.debug("Preauth hash after negotiate " + Hexdump.toHexString(this.preauthIntegrityHash));
            }
        }
    }

    protected synchronized void doDisconnect(boolean hard) throws IOException {
        this.doDisconnect(hard, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean doDisconnect(boolean hard, boolean inUse) throws IOException {
        ListIterator<SmbSessionImpl> iter = this.sessions.listIterator();
        boolean wasInUse = false;
        long l = this.getUsageCount();
        if (inUse && l != 1L || !inUse && l > 0L) {
            log.warn("Disconnecting transport while still in use " + this + ": " + this.sessions);
            wasInUse = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting transport " + this);
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("Currently " + this.sessions.size() + " session(s) active for " + this);
            }
            while (iter.hasNext()) {
                SmbSessionImpl ssn = iter.next();
                try {
                    wasInUse |= ssn.logoff(hard, false);
                }
                catch (Exception e) {
                    log.debug("Failed to close session", (Throwable)e);
                }
                finally {
                    iter.remove();
                }
            }
            if (this.socket != null) {
                this.socket.shutdownOutput();
                this.out.close();
                this.in.close();
                this.socket.close();
                log.trace("Socket closed");
            } else {
                log.trace("Not yet initialized");
            }
        }
        catch (Exception e) {
            log.debug("Exception in disconnect", (Throwable)e);
        }
        finally {
            this.socket = null;
            this.digest = null;
            this.tconHostName = null;
            this.transportContext.getTransportPool().removeTransport(this);
        }
        return wasInUse;
    }

    @Override
    protected long makeKey(jcifs.util.transport.Request request) throws IOException {
        long m = this.mid.incrementAndGet() - 1L;
        if (!this.smb2) {
            m %= 32000L;
        }
        ((CommonServerMessageBlock)((Object)request)).setMid(m);
        return m;
    }

    @Override
    protected Long peekKey() throws IOException {
        do {
            if (SmbTransportImpl.readn(this.in, this.sbuf, 0, 4) >= 4) continue;
            return null;
        } while (this.sbuf[0] == -123);
        if (SmbTransportImpl.readn(this.in, this.sbuf, 4, 32) < 32) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("New data read: " + this);
            log.trace(Hexdump.toHexString(this.sbuf, 4, 32));
        }
        while (true) {
            if (this.sbuf[0] == 0 && this.sbuf[4] == -2 && this.sbuf[5] == 83 && this.sbuf[6] == 77 && this.sbuf[7] == 66) {
                this.smb2 = true;
                int lenDiff = 32;
                if (SmbTransportImpl.readn(this.in, this.sbuf, 36, lenDiff) < lenDiff) {
                    return null;
                }
                return Encdec.dec_uint64le(this.sbuf, 28);
            }
            if (this.sbuf[0] == 0 && this.sbuf[1] == 0 && this.sbuf[4] == -1 && this.sbuf[5] == 83 && this.sbuf[6] == 77 && this.sbuf[7] == 66) break;
            for (int i = 0; i < 35; ++i) {
                log.warn("Possibly out of phase, trying to resync " + Hexdump.toHexString(this.sbuf, 0, 16));
                this.sbuf[i] = this.sbuf[i + 1];
            }
            int b = this.in.read();
            if (b == -1) {
                return null;
            }
            this.sbuf[35] = (byte)b;
        }
        return (long)Encdec.dec_uint16le(this.sbuf, 34) & 0xFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSend(jcifs.util.transport.Request request) throws IOException {
        CommonServerMessageBlock smb = (CommonServerMessageBlock)((Object)request);
        byte[] buffer = this.getContext().getBufferCache().getBuffer();
        try {
            Object object = this.outLock;
            synchronized (object) {
                int n = smb.encode(buffer, 4);
                Encdec.enc_uint32be(n & 0xFFFF, buffer, 0);
                if (log.isTraceEnabled()) {
                    do {
                        log.trace(smb.toString());
                    } while (smb instanceof AndXServerMessageBlock && (smb = ((AndXServerMessageBlock)smb).getAndx()) != null);
                    log.trace(Hexdump.toHexString(buffer, 4, n));
                }
                this.out.write(buffer, 0, 4 + n);
                this.out.flush();
            }
        }
        finally {
            this.getContext().getBufferCache().releaseBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CommonServerMessageBlockResponse> T sendrecv(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws IOException {
        if (request instanceof Request) {
            if (response == null) {
                response = ((Request)request).initResponse(this.getContext());
            } else if (this.isSMB2()) {
                throw new IOException("Should not provide response argument for SMB2");
            }
        } else {
            request.setResponse(response);
        }
        if (response == null) {
            throw new IOException("Invalid response");
        }
        CommonServerMessageBlockRequest curHead = request;
        int maxSize = this.getContext().getConfig().getMaximumBufferSize();
        while (curHead != null) {
            CommonServerMessageBlockRequest nextHead = null;
            int totalSize = 0;
            int n = 0;
            CommonServerMessageBlockRequest last = null;
            CommonServerMessageBlockRequest chain = curHead;
            while (chain != null) {
                ++n;
                int size = chain.size();
                int cost = chain.getCreditCost();
                CommonServerMessageBlockRequest next = chain.getNext();
                if (log.isTraceEnabled()) {
                    log.trace(String.format("%s costs %d avail %d (%s)", chain.getClass().getName(), cost, this.credits.availablePermits(), this.name));
                }
                if ((next == null || chain.allowChain(next)) && totalSize + size < maxSize && this.credits.tryAcquire(cost)) {
                    totalSize += size;
                    last = chain;
                    chain = next;
                    continue;
                }
                if (last == null && totalSize + size > maxSize) {
                    throw new SmbException(String.format("Request size %d exceeds allowable size %d: %s", size, maxSize, chain));
                }
                if (last == null) {
                    try {
                        long timeout = this.getResponseTimeout(chain);
                        if (params.contains((Object)RequestParam.NO_TIMEOUT)) {
                            this.credits.acquire(cost);
                        } else if (!this.credits.tryAcquire(cost, timeout, TimeUnit.MILLISECONDS)) {
                            throw new SmbException("Failed to acquire credits in time");
                        }
                        totalSize += size;
                        CommonServerMessageBlockRequest commonServerMessageBlockRequest = chain;
                        synchronized (commonServerMessageBlockRequest) {
                            CommonServerMessageBlockRequest snext;
                            nextHead = snext = chain.split();
                            if (log.isDebugEnabled() && snext != null) {
                                log.debug("Insufficient credits, send only first " + chain + " next is " + snext);
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException ie = new InterruptedIOException("Interrupted while acquiring credits");
                        ie.initCause(e);
                        throw ie;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Not enough credits, split at " + last);
                }
                CommonServerMessageBlockRequest e = last;
                synchronized (e) {
                    nextHead = last.split();
                    break;
                }
            }
            int reqCredits = Math.max(1, this.desiredCredits - this.credits.availablePermits() - n + 1);
            if (log.isTraceEnabled()) {
                log.trace("Request credits " + reqCredits);
            }
            request.setRequestCredits(reqCredits);
            CommonServerMessageBlockRequest thisReq = curHead;
            try {
                CommonServerMessageBlockResponse resp = thisReq.getResponse();
                if (log.isTraceEnabled()) {
                    log.trace("Sending " + thisReq);
                }
                if (!this.checkStatus(curHead, resp = super.sendrecv(curHead, resp, params))) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Breaking on error " + resp);
                    break;
                }
                if (nextHead != null) {
                    resp.prepare(nextHead);
                }
                curHead = nextHead;
            }
            finally {
                CommonServerMessageBlockRequest curReq = thisReq;
                int grantedCredits = 0;
                while (curReq != null) {
                    CommonServerMessageBlockRequest next;
                    if (curReq.isResponseAsync()) {
                        log.trace("Async");
                        break;
                    }
                    CommonServerMessageBlockResponse resp = curReq.getResponse();
                    if (resp.isReceived()) {
                        grantedCredits += resp.getGrantedCredits();
                    }
                    if ((next = curReq.getNext()) == null) break;
                    curReq = next;
                }
                if (!(this.isDisconnected() || curReq.isResponseAsync() || curReq.getResponse().isAsync() || curReq.getResponse().isError() || grantedCredits != 0)) {
                    if (this.credits.availablePermits() > 0 || n > 0) {
                        log.debug("Server " + this + " returned zero credits for " + curReq);
                        continue;
                    }
                    log.warn("Server " + this + " took away all our credits");
                    continue;
                }
                if (curReq.isResponseAsync()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Adding credits " + grantedCredits);
                }
                this.credits.release(grantedCredits);
            }
        }
        if (!response.isReceived()) {
            throw new IOException("No response", response.getException());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends Response> boolean handleIntermediate(jcifs.util.transport.Request request, T response) {
        ServerMessageBlock2Response resp;
        if (!this.smb2) {
            return false;
        }
        ServerMessageBlock2Request req = (ServerMessageBlock2Request)request;
        ServerMessageBlock2Response serverMessageBlock2Response = resp = (ServerMessageBlock2Response)response;
        synchronized (serverMessageBlock2Response) {
            if (resp.isAsync() && !resp.isAsyncHandled() && resp.getStatus() == 259 && resp.getAsyncId() != 0L) {
                resp.setAsyncHandled(true);
                boolean first = !req.isAsync();
                req.setAsyncId(resp.getAsyncId());
                Long exp = resp.getExpiration();
                if (exp != null) {
                    resp.setExpiration(System.currentTimeMillis() + (long)this.getResponseTimeout(request));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Have intermediate reply " + response);
                }
                if (first) {
                    int credit = resp.getCredit();
                    if (log.isDebugEnabled()) {
                        log.debug("Credit from intermediate " + credit);
                    }
                    this.credits.release(credit);
                }
                return true;
            }
        }
        return false;
    }

    protected void doSend0(jcifs.util.transport.Request request) throws IOException {
        try {
            this.doSend(request);
        }
        catch (IOException ioe) {
            log.warn("send failed", (Throwable)ioe);
            try {
                this.disconnect(true);
            }
            catch (IOException ioe2) {
                ioe.addSuppressed(ioe2);
                log.error("disconnect failed", (Throwable)ioe2);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRecv(Response response) throws IOException {
        CommonServerMessageBlock resp = (CommonServerMessageBlock)((Object)response);
        this.negotiated.setupResponse(response);
        try {
            if (this.smb2) {
                this.doRecvSMB2(resp);
            } else {
                this.doRecvSMB1(resp);
            }
        }
        catch (Exception e) {
            log.warn("Failure decoding message, disconnecting transport", (Throwable)e);
            response.exception(e);
            Response response2 = response;
            synchronized (response2) {
                response.notifyAll();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecvSMB2(CommonServerMessageBlock response) throws IOException, SMBProtocolDecodingException {
        int msgSize;
        int size = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF | (this.sbuf[1] & 0xFF) << 16;
        if (size < 65) {
            throw new IOException("Invalid payload size: " + size);
        }
        if (this.sbuf[0] != 0 || this.sbuf[4] != -2 || this.sbuf[5] != 83 || this.sbuf[6] != 77 || this.sbuf[7] != 66) {
            throw new IOException("Houston we have a synchronization problem");
        }
        int nextCommand = Encdec.dec_uint32le(this.sbuf, 24);
        int maximumBufferSize = this.getContext().getConfig().getMaximumBufferSize();
        int n = msgSize = nextCommand != 0 ? nextCommand : size;
        if (msgSize > maximumBufferSize) {
            throw new IOException(String.format("Message size %d exceeds maxiumum buffer size %d", msgSize, maximumBufferSize));
        }
        ServerMessageBlock2Response cur = (ServerMessageBlock2Response)response;
        byte[] buffer = this.getContext().getBufferCache().getBuffer();
        try {
            int rl = nextCommand != 0 ? nextCommand : size;
            System.arraycopy(this.sbuf, 4, buffer, 0, 64);
            SmbTransportImpl.readn(this.in, buffer, 64, rl - 64);
            cur.setReadSize(rl);
            int len = cur.decode(buffer, 0);
            if (len > rl) {
                throw new IOException(String.format("WHAT? ( read %d decoded %d ): %s", rl, len, cur));
            }
            if (nextCommand != 0 && len > nextCommand) {
                throw new IOException("Overlapping commands");
            }
            size -= rl;
            while (size > 0 && nextCommand != 0) {
                if ((cur = (ServerMessageBlock2Response)cur.getNextResponse()) == null) {
                    log.warn("Response not properly set up");
                    this.in.skip(size);
                    break;
                }
                SmbTransportImpl.readn(this.in, buffer, 0, 64);
                nextCommand = Encdec.dec_uint32le(buffer, 20);
                if (nextCommand != 0 && nextCommand > maximumBufferSize || nextCommand == 0 && size > maximumBufferSize) {
                    throw new IOException(String.format("Message size %d exceeds maxiumum buffer size %d", nextCommand != 0 ? nextCommand : size, maximumBufferSize));
                }
                int n2 = rl = nextCommand != 0 ? nextCommand : size;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Compound next command %d read size %d remain %d", nextCommand, rl, size));
                }
                cur.setReadSize(rl);
                SmbTransportImpl.readn(this.in, buffer, 64, rl - 64);
                len = cur.decode(buffer, 0, true);
                if (len > rl) {
                    throw new IOException(String.format("WHAT? ( read %d decoded %d ): %s", rl, len, cur));
                }
                if (nextCommand != 0 && len > nextCommand) {
                    throw new IOException("Overlapping commands");
                }
                size -= rl;
            }
        }
        finally {
            this.getContext().getBufferCache().releaseBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecvSMB1(CommonServerMessageBlock resp) throws IOException, SMBProtocolDecodingException {
        byte[] buffer = this.getContext().getBufferCache().getBuffer();
        try {
            System.arraycopy(this.sbuf, 0, buffer, 0, 36);
            int size = Encdec.dec_uint16be(buffer, 2) & 0xFFFF;
            if (size < 33 || 4 + size > Math.min(65535, this.getContext().getConfig().getMaximumBufferSize())) {
                throw new IOException("Invalid payload size: " + size);
            }
            int errorCode = Encdec.dec_uint32le(buffer, 9) & 0xFFFFFFFF;
            if (resp.getCommand() == 46 && (errorCode == 0 || errorCode == -2147483643)) {
                SmbComReadAndXResponse r = (SmbComReadAndXResponse)resp;
                int off = 32;
                SmbTransportImpl.readn(this.in, buffer, 4 + off, 27);
                resp.decode(buffer, 4);
                int pad = r.getDataOffset() - (off += 27);
                if (r.getByteCount() > 0 && pad > 0 && pad < 4) {
                    SmbTransportImpl.readn(this.in, buffer, 4 + off, pad);
                }
                if (r.getDataLength() > 0) {
                    SmbTransportImpl.readn(this.in, r.getData(), r.getOffset(), r.getDataLength());
                }
            } else {
                SmbTransportImpl.readn(this.in, buffer, 36, size - 32);
                resp.decode(buffer, 4);
            }
        }
        finally {
            this.getContext().getBufferCache().releaseBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSkip(Long key) throws IOException {
        Object object = this.inLock;
        synchronized (object) {
            int size = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
            if (size < 33 || 4 + size > this.getContext().getConfig().getReceiveBufferSize()) {
                log.warn("Flusing stream input");
                this.in.skip(this.in.available());
            } else {
                Response notification = this.createNotification(key);
                if (notification != null) {
                    log.debug("Parsing notification");
                    this.doRecv(notification);
                    this.handleNotification(notification);
                    return;
                }
                log.warn("Skipping message " + key);
                this.in.skip(size - 32);
            }
        }
    }

    protected void handleNotification(Response notification) {
        log.info("Received notification " + notification);
    }

    protected Response createNotification(Long key) throws SmbException {
        if (key == null) {
            return null;
        }
        if (this.smb2) {
            if (key != -1L) {
                return null;
            }
            int cmd = Encdec.dec_uint16le(this.sbuf, 16) & 0xFFFF;
            if (cmd == 18) {
                return new Smb2OplockBreakNotification(this.getContext().getConfig());
            }
        } else {
            if (key != 65535L) {
                return null;
            }
            byte cmd = this.sbuf[8];
            if (cmd == 36) {
                return new SmbComLockingAndX(this.getContext().getConfig());
            }
        }
        return null;
    }

    boolean checkStatus(ServerMessageBlock req, ServerMessageBlock resp) throws SmbException {
        boolean cont = false;
        if (resp.getErrorCode() == 196610) {
            resp.setErrorCode(-1073741225);
        } else {
            resp.setErrorCode(SmbException.getStatusByCode(resp.getErrorCode()));
        }
        switch (resp.getErrorCode()) {
            case 0: {
                cont = true;
                break;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741428: 
            case -1073741260: {
                throw new SmbAuthException(resp.getErrorCode());
            }
            case -1073741637: {
                throw new SmbUnsupportedOperationException();
            }
            case -1073741662: 
            case -1073741225: {
                this.checkReferral(resp, req.getPath(), req);
            }
            case -2147483643: {
                break;
            }
            case -1073741802: {
                break;
            }
            default: {
                if (log.isDebugEnabled()) {
                    log.debug("Error code: 0x" + Hexdump.toHexString(resp.getErrorCode(), 8) + " for " + req.getClass().getSimpleName());
                }
                throw new SmbException(resp.getErrorCode(), null);
            }
        }
        if (resp.isVerifyFailed()) {
            throw new SmbException("Signature verification failed.");
        }
        return cont;
    }

    boolean checkStatus2(ServerMessageBlock2 req, Response resp) throws SmbException {
        boolean cont = false;
        switch (resp.getErrorCode()) {
            case -2147483642: 
            case 0: {
                cont = true;
                break;
            }
            case 259: {
                cont = false;
                break;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741428: 
            case -1073741260: {
                throw new SmbAuthException(resp.getErrorCode());
            }
            case -1073741802: {
                break;
            }
            case 267: 
            case 268: {
                break;
            }
            case -1073741808: 
            case -1073741637: {
                throw new SmbUnsupportedOperationException();
            }
            case -1073741225: {
                if (!(req instanceof RequestWithPath)) {
                    throw new SmbException("Invalid request for a DFS NT_STATUS_PATH_NOT_COVERED response " + req.getClass().getName());
                }
                String path = ((RequestWithPath)((Object)req)).getFullUNCPath();
                this.checkReferral(resp, path, (RequestWithPath)((Object)req));
                break;
            }
            case -2147483643: {
                int ctlCode;
                if (resp instanceof Smb2ReadResponse || resp instanceof Smb2IoctlResponse && ((ctlCode = ((Smb2IoctlResponse)resp).getCtlCode()) == 1163287 || ctlCode == 1130508)) break;
            }
            default: {
                if (log.isDebugEnabled()) {
                    log.debug("Error code: 0x" + Hexdump.toHexString(resp.getErrorCode(), 8) + " for " + req.getClass().getSimpleName());
                }
                throw new SmbException(resp.getErrorCode(), null);
            }
        }
        if (resp.isVerifyFailed()) {
            throw new SMBSignatureValidationException("Signature verification failed.");
        }
        return cont;
    }

    private void checkReferral(Response resp, String path, RequestWithPath req) throws SmbException, DfsReferral {
        DfsReferralData dr = null;
        if (!this.getContext().getConfig().isDfsDisabled()) {
            try {
                dr = this.getDfsReferrals(this.getContext(), path, req.getServer(), req.getDomain(), 1);
            }
            catch (CIFSException e) {
                throw new SmbException("Failed to get DFS referral", (Throwable)e);
            }
        }
        if (dr == null) {
            if (log.isDebugEnabled()) {
                log.debug("Error code: 0x" + Hexdump.toHexString(resp.getErrorCode(), 8));
            }
            throw new SmbException(resp.getErrorCode(), null);
        }
        if (req.getDomain() != null && this.getContext().getConfig().isDfsConvertToFQDN() && dr instanceof DfsReferralDataImpl) {
            ((DfsReferralDataImpl)dr).fixupDomain(req.getDomain());
        }
        if (log.isDebugEnabled()) {
            log.debug("Got referral " + dr);
        }
        this.getContext().getDfs().cache(this.getContext(), path, dr);
        throw new DfsReferral(dr);
    }

    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response) throws SmbException {
        return this.send(request, response, Collections.emptySet());
    }

    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws SmbException {
        this.ensureConnected();
        if (this.smb2 && !(request instanceof ServerMessageBlock2)) {
            throw new SmbException("Not an SMB2 request " + request.getClass().getName());
        }
        if (!this.smb2 && !(request instanceof ServerMessageBlock)) {
            throw new SmbException("Not an SMB1 request");
        }
        this.negotiated.setupRequest(request);
        if (response != null) {
            request.setResponse(response);
            response.setDigest(request.getDigest());
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("Sending " + request);
            }
            if (request.isCancel()) {
                this.doSend0(request);
                return null;
            }
            if (request instanceof SmbComTransaction) {
                response = this.sendComTransaction(request, response, params);
            } else {
                if (response != null) {
                    response.setCommand(request.getCommand());
                }
                response = this.sendrecv(request, response, params);
            }
        }
        catch (SmbException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SmbException(ioe.getMessage(), (Throwable)ioe);
        }
        if (log.isTraceEnabled()) {
            log.trace("Response is " + response);
        }
        this.checkStatus(request, response);
        return response;
    }

    private <T extends CommonServerMessageBlockResponse> boolean checkStatus(CommonServerMessageBlockRequest request, T response) throws SmbException {
        for (CommonServerMessageBlockRequest cur = request; cur != null; cur = cur.getNext()) {
            if (!(this.smb2 ? !this.checkStatus2((ServerMessageBlock2)((Object)cur), cur.getResponse()) : !this.checkStatus((ServerMessageBlock)cur, (ServerMessageBlock)cur.getResponse()))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CommonServerMessageBlock & Response> T sendComTransaction(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws IOException, SmbException, TransportException, EOFException {
        response.setCommand(request.getCommand());
        SmbComTransaction req = (SmbComTransaction)request;
        SmbComTransactionResponse resp = (SmbComTransactionResponse)response;
        resp.reset();
        try {
            SmbComTransactionResponse smbComTransactionResponse;
            long k;
            req.setBuffer(this.getContext().getBufferCache().getBuffer());
            req.nextElement();
            if (req.hasMoreElements()) {
                SmbComBlankResponse interim = new SmbComBlankResponse(this.getContext().getConfig());
                super.sendrecv(req, interim, params);
                if (interim.getErrorCode() != 0) {
                    this.checkStatus(req, interim);
                }
                k = req.nextElement().getMid();
            } else {
                k = this.makeKey(req);
            }
            try {
                resp.clearReceived();
                long timeout = this.getResponseTimeout(req);
                if (!params.contains((Object)RequestParam.NO_TIMEOUT)) {
                    resp.setExpiration(System.currentTimeMillis() + timeout);
                } else {
                    resp.setExpiration(null);
                }
                byte[] txbuf = this.getContext().getBufferCache().getBuffer();
                resp.setBuffer(txbuf);
                this.response_map.put(k, resp);
                do {
                    this.doSend0(req);
                } while (req.hasMoreElements() && req.nextElement() != null);
                smbComTransactionResponse = resp;
                synchronized (smbComTransactionResponse) {
                    while (!resp.isReceived() || resp.hasMoreElements()) {
                        if (!params.contains((Object)RequestParam.NO_TIMEOUT)) {
                            resp.wait(timeout);
                            timeout = resp.getExpiration() - System.currentTimeMillis();
                            if (timeout > 0L) continue;
                            throw new TransportException(this + " timedout waiting for response to " + req);
                        }
                        resp.wait();
                        if (log.isTraceEnabled()) {
                            log.trace("Wait returned " + this.isDisconnected());
                        }
                        if (!this.isDisconnected()) continue;
                        throw new EOFException("Transport closed while waiting for result");
                    }
                }
                if (!resp.isReceived()) {
                    throw new TransportException("Failed to read response");
                }
                if (resp.getErrorCode() != 0) {
                    this.checkStatus(req, resp);
                }
                smbComTransactionResponse = response;
                this.response_map.remove(k);
            }
            catch (Throwable throwable) {
                try {
                    this.response_map.remove(k);
                    this.getContext().getBufferCache().releaseBuffer(resp.releaseBuffer());
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    throw new TransportException(ie);
                }
            }
            this.getContext().getBufferCache().releaseBuffer(resp.releaseBuffer());
            return (T)smbComTransactionResponse;
        }
        finally {
            this.getContext().getBufferCache().releaseBuffer(req.releaseBuffer());
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.address + ":" + this.port + ",state=" + this.state + ",signingEnforced=" + this.signingEnforced + ",usage=" + this.getUsageCount() + "]";
    }

    /*
     * Exception decompiling
     */
    @Override
    public DfsReferralData getDfsReferrals(CIFSContext ctx, String path, String targetHost, String targetDomain, int rn) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    byte[] getPreauthIntegrityHash() {
        return this.preauthIntegrityHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreauthHash(byte[] input) throws CIFSException {
        byte[] byArray = this.preauthIntegrityHash;
        synchronized (this.preauthIntegrityHash) {
            this.preauthIntegrityHash = this.calculatePreauthHash(input, 0, input.length, this.preauthIntegrityHash);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    byte[] calculatePreauthHash(byte[] input, int off, int len, byte[] oldHash) throws CIFSException {
        MessageDigest dgst;
        if (!this.smb2 || this.negotiated == null) {
            throw new SmbUnsupportedOperationException();
        }
        Smb2NegotiateResponse resp = (Smb2NegotiateResponse)this.negotiated;
        if (!resp.getSelectedDialect().atLeast(DialectVersion.SMB311)) {
            throw new SmbUnsupportedOperationException();
        }
        switch (resp.getSelectedPreauthHash()) {
            case 1: {
                dgst = Crypto.getSHA512();
                break;
            }
            default: {
                throw new SmbUnsupportedOperationException();
            }
        }
        if (oldHash != null) {
            dgst.update(oldHash);
        }
        dgst.update(input, off, len);
        return dgst.digest();
    }

    Cipher createEncryptionCipher(byte[] key) throws CIFSException {
        if (!this.smb2 || this.negotiated == null) {
            throw new SmbUnsupportedOperationException();
        }
        Smb2NegotiateResponse resp = (Smb2NegotiateResponse)this.negotiated;
        int cipherId = -1;
        if (resp.getSelectedDialect().atLeast(DialectVersion.SMB311)) {
            cipherId = resp.getSelectedCipher();
        } else if (resp.getSelectedDialect().atLeast(DialectVersion.SMB300)) {
            cipherId = 1;
        } else {
            throw new SmbUnsupportedOperationException();
        }
        switch (cipherId) {
            default: 
        }
        throw new SmbUnsupportedOperationException();
    }

    public int getRequestSecurityMode(Smb2NegotiateResponse first) {
        int securityMode = 1;
        if (this.signingEnforced || first != null && first.isSigningRequired()) {
            securityMode = 3;
        }
        return securityMode;
    }
}

