/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.RuntimeCIFSException;
import jcifs.smb.RequestParam;
import jcifs.util.transport.ConnectionTimeoutException;
import jcifs.util.transport.Request;
import jcifs.util.transport.RequestTimeoutException;
import jcifs.util.transport.Response;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Transport
implements Runnable,
AutoCloseable {
    private static int id = 0;
    private static final Logger log = LoggerFactory.getLogger(Transport.class);
    protected volatile int state = 0;
    protected String name = "Transport" + id++;
    private volatile Thread thread;
    private volatile TransportException te;
    protected final Object inLock = new Object();
    protected final Object outLock = new Object();
    protected final Map<Long, Response> response_map = new ConcurrentHashMap<Long, Response>(10);
    private final AtomicLong usageCount = new AtomicLong(1L);

    public static int readn(InputStream in, byte[] b, int off, int len) throws IOException {
        int i;
        int n = -5;
        if (off + len > b.length) {
            throw new IOException("Buffer too short, bufsize " + b.length + " read " + len);
        }
        for (i = 0; i < len && (n = in.read(b, off + i, len - i)) > 0; i += n) {
        }
        return i;
    }

    public Transport acquire() {
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Acquire transport " + usage + " " + this);
        }
        return this;
    }

    @Override
    public void close() {
        this.release();
    }

    public void release() {
        long usage = this.usageCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Release transport " + usage + " " + this);
        }
        if (usage == 0L) {
            if (log.isTraceEnabled()) {
                log.trace("Transport usage dropped to zero " + this);
            }
        } else if (usage < 0L) {
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isDisconnected() && this.usageCount.get() != 0L) {
            log.warn("Session was not properly released");
        }
    }

    protected long getUsageCount() {
        return this.usageCount.get();
    }

    protected abstract long makeKey(Request var1) throws IOException;

    protected abstract Long peekKey() throws IOException;

    protected abstract void doSend(Request var1) throws IOException;

    protected abstract void doRecv(Response var1) throws IOException;

    protected abstract void doSkip(Long var1) throws IOException;

    public boolean isDisconnected() {
        return this.state == 4 || this.state == 5 || this.state == 6 || this.state == 0;
    }

    public boolean isFailed() {
        return this.state == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Response> T sendrecv(Request request, T response, Set<RequestParam> params) throws IOException {
        if (this.isDisconnected() && this.state != 5) {
            throw new TransportException("Transport is disconnected " + this.name);
        }
        try {
            Object object;
            long timeout = !params.contains((Object)RequestParam.NO_TIMEOUT) ? (long)this.getResponseTimeout(request) : 0L;
            long firstKey = this.doSend(request, response, params, timeout);
            if (Thread.currentThread() == this.thread) {
                object = this.inLock;
                synchronized (object) {
                    Long peekKey;
                    block16: {
                        peekKey = this.peekKey();
                        if (peekKey != firstKey) break block16;
                        this.doRecv(response);
                        response.received();
                        T t = response;
                        return t;
                    }
                    this.doSkip(peekKey);
                }
            }
            object = this.waitForResponses(request, response, timeout);
            return (T)object;
        }
        catch (IOException ioe) {
            log.warn("sendrecv failed", (Throwable)ioe);
            try {
                this.disconnect(true);
            }
            catch (IOException ioe2) {
                ioe.addSuppressed(ioe2);
                log.info("disconnect failed", (Throwable)ioe2);
            }
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw new TransportException(ie);
        }
        finally {
            Object curResp = response;
            Request curReq = request;
            while (curResp != null) {
                this.response_map.remove(curResp.getMid());
                Request next = curReq.getNext();
                if (next == null) break;
                curReq = next;
                curResp = next.getResponse();
            }
        }
    }

    protected <T extends Response> long doSend(Request request, T response, Set<RequestParam> params, long timeout) throws IOException {
        long firstKey = this.prepareRequests(request, response, params, timeout);
        this.doSend(request);
        return firstKey;
    }

    private <T extends Response> long prepareRequests(Request request, T response, Set<RequestParam> params, long timeout) throws IOException {
        Object curResp = response;
        Request curReq = request;
        long firstKey = 0L;
        while (curResp != null) {
            curResp.reset();
            if (params.contains((Object)RequestParam.RETAIN_PAYLOAD)) {
                curResp.retainPayload();
            }
            long k = this.makeKey(curReq);
            if (firstKey == 0L) {
                firstKey = k;
            }
            if (timeout > 0L) {
                curResp.setExpiration(System.currentTimeMillis() + timeout);
            } else {
                curResp.setExpiration(null);
            }
            curResp.setMid(k);
            this.response_map.put(k, (Response)curResp);
            Request next = curReq.getNext();
            if (next == null) break;
            curReq = next;
            curResp = next.getResponse();
        }
        return firstKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Response> T waitForResponses(Request request, T response, long timeout) throws InterruptedException, TransportException {
        Object curResp = response;
        Request curReq = request;
        while (curResp != null) {
            T t = curResp;
            synchronized (t) {
                if (!curResp.isReceived()) {
                    if (timeout > 0L) {
                        curResp.wait(timeout);
                        if (!curResp.isReceived() && this.handleIntermediate(curReq, curResp)) {
                            continue;
                        }
                        if (curResp.isError()) {
                            throw new TransportException(this.name + " error reading response to " + curReq, curResp.getException());
                        }
                        if (this.isDisconnected() && this.state != 5) {
                            throw new TransportException(String.format("Transport was disconnected while waiting for a response (transport: %s state: %d),", this.name, this.state));
                        }
                        timeout = curResp.getExpiration() - System.currentTimeMillis();
                        if (timeout <= 0L) {
                            if (log.isDebugEnabled()) {
                                log.debug("State is " + this.state);
                            }
                            throw new RequestTimeoutException(this.name + " timedout waiting for response to " + curReq);
                        }
                        continue;
                    }
                    curResp.wait();
                    if (this.handleIntermediate(request, curResp)) {
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Wait returned state is " + this.state);
                    }
                    if (this.isDisconnected()) {
                        throw new InterruptedException("Transport was disconnected while waiting for a response");
                    }
                    continue;
                }
            }
            Request next = curReq.getNext();
            if (next == null) break;
            curReq = next;
            curResp = next.getResponse();
        }
        return response;
    }

    protected <T extends Response> boolean handleIntermediate(Request request, T response) {
        return false;
    }

    protected abstract int getResponseTimeout(Request var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        while (this.thread == Thread.currentThread()) {
            try {
                Object object = this.inLock;
                synchronized (object) {
                    Long key;
                    try {
                        key = this.peekKey();
                    }
                    catch (SocketTimeoutException e) {
                        log.trace("Socket timeout during peekKey", (Throwable)e);
                        if (this.getUsageCount() > 0L) {
                            if (log.isDebugEnabled()) {
                                log.debug("Transport still in use, no idle timeout " + this);
                            }
                            Iterator<Response> iterator = this.response_map.values().iterator();
                            while (iterator.hasNext()) {
                                Response response;
                                Response response2 = response = iterator.next();
                                synchronized (response2) {
                                    response.notifyAll();
                                }
                            }
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Idle timeout on %s", this.name));
                        }
                        throw e;
                    }
                    if (key == null) {
                        Transport e = this;
                        synchronized (e) {
                            for (Response response : this.response_map.values()) {
                                response.error();
                            }
                        }
                        throw new IOException("end of stream");
                    }
                    Response response = this.response_map.get(key);
                    if (response == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Unexpected message id, skipping message " + key);
                        }
                        this.doSkip(key);
                    } else {
                        this.doRecv(response);
                        response.received();
                    }
                }
            }
            catch (Exception ex) {
                boolean closed;
                String msg = ex.getMessage();
                boolean timeout = ex instanceof SocketTimeoutException || msg != null && msg.equals("Read timed out");
                boolean bl = closed = msg != null && msg.equals("Socket closed");
                if (closed) {
                    log.trace("Remote closed connection");
                } else if (!timeout) {
                    log.debug("recv failed", (Throwable)ex);
                }
                Transport transport = this;
                synchronized (transport) {
                    try {
                        this.disconnect(!timeout, false);
                    }
                    catch (IOException ioe) {
                        ex.addSuppressed(ioe);
                        log.warn("Failed to disconnect", (Throwable)ioe);
                    }
                    log.debug("Disconnected");
                    Iterator<Map.Entry<Long, Response>> iterator = this.response_map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Response resp = iterator.next().getValue();
                        resp.exception(ex);
                        iterator.remove();
                    }
                    log.debug("Notified clients");
                    return;
                }
            }
        }
    }

    protected abstract void doConnect() throws Exception;

    protected abstract boolean doDisconnect(boolean var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean connect(long timeout) throws TransportException {
        int st = this.state;
        try {
            switch (st) {
                case 0: {
                    break;
                }
                case 1: {
                    this.thread.wait(timeout);
                    st = this.state;
                    switch (st) {
                        case 1: {
                            this.state = 6;
                            this.cleanupThread();
                            throw new ConnectionTimeoutException("Connection timeout");
                        }
                        case 2: {
                            if (this.te != null) {
                                this.state = 4;
                                this.cleanupThread();
                                throw this.te;
                            }
                            this.state = 3;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    break;
                }
                case 3: {
                    boolean bl = true;
                    return bl;
                }
                case 4: {
                    this.state = 6;
                    throw new TransportException("Connection in error", this.te);
                }
                case 5: 
                case 6: {
                    log.debug("Trying to connect a disconnected transport");
                    boolean bl = false;
                    return bl;
                }
                default: {
                    TransportException tex = new TransportException("Invalid state: " + st);
                    throw tex;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Connecting " + this.name);
            }
            this.state = 1;
            this.te = null;
            Thread t = new Thread((Runnable)this, this.name);
            t.setDaemon(true);
            Thread thread = this.thread = t;
            synchronized (thread) {
                t.start();
                t.wait(timeout);
                st = this.state;
                switch (st) {
                    case 1: {
                        this.state = 6;
                        break;
                    }
                    case 2: {
                        if (this.te == null) {
                            this.state = 3;
                            boolean bl = true;
                            return bl;
                        }
                        this.state = 4;
                        break;
                    }
                    case 3: {
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 22, 25, 10] lbl62 : MonitorExitStatement: MONITOREXIT : var5_9
                        st = this.state;
                        if (st == 0) return bl;
                        if (st == 3) return bl;
                        if (st == 4) return bl;
                        if (st == 5) return bl;
                        if (st == 6) return bl;
                        log.error("Invalid state: " + st);
                        this.state = 6;
                        this.cleanupThread();
                        return bl;
                    }
                    default: {
                        boolean bl = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 22, 10, 26] lbl75 : MonitorExitStatement: MONITOREXIT : var5_9
                        st = this.state;
                        if (st == 0) return bl;
                        if (st == 3) return bl;
                        if (st == 4) return bl;
                        if (st == 5) return bl;
                        if (st == 6) return bl;
                        log.error("Invalid state: " + st);
                        this.state = 6;
                        this.cleanupThread();
                        return bl;
                    }
                }
            }
            this.cleanupThread();
            switch (st) {
                case 1: {
                    this.state = 0;
                    throw new ConnectionTimeoutException("Connection timeout");
                }
                case 2: {
                    throw this.te;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.state = 6;
            this.cleanupThread();
            throw new TransportException(ie);
        }
        finally {
            st = this.state;
            if (st != 0 && st != 3 && st != 4 && st != 5 && st != 6) {
                log.error("Invalid state: " + st);
                this.state = 6;
                this.cleanupThread();
            }
        }
    }

    private synchronized void cleanupThread() throws TransportException {
        Thread t = this.thread;
        if (t != null && Thread.currentThread() != t) {
            this.thread = null;
            try {
                log.debug("Interrupting transport thread");
                t.interrupt();
                log.debug("Joining transport thread");
                t.join();
                log.debug("Joined transport thread");
            }
            catch (InterruptedException e) {
                throw new TransportException("Failed to join transport thread", e);
            }
        } else if (t != null) {
            this.thread = null;
        }
    }

    public synchronized boolean disconnect(boolean hard) throws IOException {
        return this.disconnect(hard, true);
    }

    public synchronized boolean disconnect(boolean hard, boolean inUse) throws IOException {
        IOException ioe = null;
        switch (this.state) {
            case 0: 
            case 5: 
            case 6: {
                return false;
            }
            case 2: {
                hard = true;
            }
            case 3: {
                if (this.response_map.size() != 0 && !hard && inUse) break;
                try {
                    this.state = 5;
                    boolean wasInUse = this.doDisconnect(hard, inUse);
                    this.state = 6;
                    return wasInUse;
                }
                catch (IOException ioe0) {
                    this.state = 6;
                    ioe = ioe0;
                }
            }
            case 4: {
                this.thread = null;
                this.state = 6;
                break;
            }
            default: {
                log.error("Invalid state: " + this.state);
                this.thread = null;
                this.state = 6;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread run_thread = Thread.currentThread();
        Exception ex0 = null;
        try {
            if (this.state != 5 && this.state != 6) {
                this.doConnect();
            }
        }
        catch (Exception ex) {
            ex0 = ex;
            return;
        }
        finally {
            Thread thread = run_thread;
            synchronized (thread) {
                if (run_thread != this.thread) {
                    if (ex0 instanceof SocketTimeoutException) {
                        log.debug("Timeout connecting", (Throwable)ex0);
                    } else if (ex0 != null) {
                        log.warn("Exception in transport thread", (Throwable)ex0);
                    }
                    return;
                }
                if (ex0 instanceof SocketTimeoutException) {
                    this.te = new ConnectionTimeoutException(ex0);
                } else if (ex0 != null) {
                    this.te = new TransportException(ex0);
                }
                this.state = 2;
                run_thread.notify();
            }
        }
        this.loop();
    }

    public String toString() {
        return this.name;
    }
}

