/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import jcifs.spnego.SpnegoToken;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class NegTokenTarg
extends SpnegoToken {
    public static final int UNSPECIFIED_RESULT = -1;
    public static final int ACCEPT_COMPLETED = 0;
    public static final int ACCEPT_INCOMPLETE = 1;
    public static final int REJECTED = 2;
    public static final int REQUEST_MIC = 3;
    private ASN1ObjectIdentifier mechanism;
    private int result = -1;

    public NegTokenTarg() {
    }

    public NegTokenTarg(int result, ASN1ObjectIdentifier mechanism, byte[] mechanismToken, byte[] mechanismListMIC) {
        this.setResult(result);
        this.setMechanism(mechanism);
        this.setMechanismToken(mechanismToken);
        this.setMechanismListMIC(mechanismListMIC);
    }

    public NegTokenTarg(byte[] token) throws IOException {
        this.parse(token);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public ASN1ObjectIdentifier getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(ASN1ObjectIdentifier mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] mechanismListMIC;
            byte[] mechanismToken;
            ASN1ObjectIdentifier mech;
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            DEROutputStream der = new DEROutputStream((OutputStream)collector);
            ASN1EncodableVector fields = new ASN1EncodableVector();
            int res = this.getResult();
            if (res != -1) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Enumerated(res)));
            }
            if ((mech = this.getMechanism()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)mech));
            }
            if ((mechanismToken = this.getMechanismToken()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(mechanismToken)));
            }
            if ((mechanismListMIC = this.getMechanismListMIC()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 3, (ASN1Encodable)new DEROctetString(mechanismListMIC)));
            }
            der.writeObject((ASN1Primitive)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(fields)));
            return collector.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    protected void parse(byte[] token) throws IOException {
        try (ASN1InputStream der = new ASN1InputStream(token);){
            ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
            ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
            Enumeration fields = sequence.getObjects();
            block11: while (fields.hasMoreElements()) {
                tagged = (ASN1TaggedObject)fields.nextElement();
                switch (tagged.getTagNo()) {
                    case 0: {
                        ASN1Enumerated enumerated = ASN1Enumerated.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setResult(enumerated.getValue().intValue());
                        continue block11;
                    }
                    case 1: {
                        this.setMechanism(ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)tagged, (boolean)true));
                        continue block11;
                    }
                    case 2: {
                        ASN1OctetString mechanismToken = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismToken(mechanismToken.getOctets());
                        continue block11;
                    }
                    case 3: {
                        ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismListMIC(mechanismListMIC.getOctets());
                        continue block11;
                    }
                }
                throw new IOException("Malformed token field.");
            }
        }
    }
}

