/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.tree;

import java.nio.charset.StandardCharsets;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.ServerMessageBlock2;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.tree.Smb2TreeConnectResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2TreeConnectRequest
extends ServerMessageBlock2Request<Smb2TreeConnectResponse> {
    private int treeFlags;
    private String path;

    public Smb2TreeConnectRequest(Configuration config, String path) {
        super(config, 3);
        this.path = path;
    }

    @Override
    protected Smb2TreeConnectResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2TreeConnectResponse> req) {
        return new Smb2TreeConnectResponse(tc.getConfig());
    }

    @Override
    public boolean chain(ServerMessageBlock2 n) {
        n.setTreeId(-1);
        return super.chain(n);
    }

    @Override
    public int size() {
        return Smb2TreeConnectRequest.size8(72 + this.path.length() * 2);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(9L, dst, dstIndex);
        SMBUtil.writeInt2(this.treeFlags, dst, dstIndex + 2);
        byte[] data = this.path.getBytes(StandardCharsets.UTF_16LE);
        int offsetOffset = dstIndex += 4;
        SMBUtil.writeInt2(data.length, dst, dstIndex + 2);
        SMBUtil.writeInt2((dstIndex += 4) - this.getHeaderStart(), dst, offsetOffset);
        System.arraycopy(data, 0, dst, dstIndex, data.length);
        return (dstIndex += data.length) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

