/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.spnego.NegTokenInit;
import jcifs.spnego.NegTokenTarg;
import jcifs.spnego.SpnegoException;
import jcifs.spnego.SpnegoToken;
import jcifs.util.Hexdump;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpnegoContext
implements SSPContext {
    private static final Logger log = LoggerFactory.getLogger(SpnegoContext.class);
    private static ASN1ObjectIdentifier SPNEGO_MECH_OID;
    private SSPContext mechContext;
    private boolean firstResponse = true;
    private boolean completed;
    private ASN1ObjectIdentifier[] mechs;
    private ASN1ObjectIdentifier selectedMech;
    private ASN1ObjectIdentifier[] remoteMechs;
    private boolean disableMic;
    private boolean requireMic;

    SpnegoContext(Configuration config, SSPContext source) {
        this(config, source, source.getSupportedMechs());
    }

    SpnegoContext(Configuration config, SSPContext source, ASN1ObjectIdentifier[] mech) {
        this.mechContext = source;
        this.mechs = mech;
        this.disableMic = !config.isEnforceSpnegoIntegrity() && config.isDisableSpnegoIntegrity();
        this.requireMic = config.isEnforceSpnegoIntegrity();
    }

    @Override
    public ASN1ObjectIdentifier[] getSupportedMechs() {
        return new ASN1ObjectIdentifier[]{SPNEGO_MECH_OID};
    }

    @Override
    public int getFlags() {
        return this.mechContext.getFlags();
    }

    @Override
    public boolean isSupported(ASN1ObjectIdentifier mechanism) {
        return false;
    }

    ASN1ObjectIdentifier[] getMechs() {
        return this.mechs;
    }

    ASN1ObjectIdentifier[] getRemoteMechs() {
        return this.remoteMechs;
    }

    void setMechs(ASN1ObjectIdentifier[] mechs) {
        this.mechs = mechs;
    }

    @Override
    public String getNetbiosName() {
        return null;
    }

    @Override
    public byte[] getSigningKey() throws CIFSException {
        return this.mechContext.getSigningKey();
    }

    @Override
    public byte[] initSecContext(byte[] inputBuf, int offset, int len) throws CIFSException {
        if (this.completed) {
            throw new CIFSException("Already complete");
        }
        SpnegoToken resp = len == 0 ? this.initialToken() : this.negotitate(inputBuf, offset, len);
        if (resp == null) {
            return null;
        }
        return resp.toByteArray();
    }

    private SpnegoToken negotitate(byte[] inputBuf, int offset, int len) throws CIFSException {
        NegTokenTarg targ;
        SpnegoToken spToken = SpnegoContext.getToken(inputBuf, offset, len);
        byte[] inputToken = null;
        if (spToken instanceof NegTokenInit) {
            NegTokenInit tinit = (NegTokenInit)spToken;
            ASN1ObjectIdentifier[] rm = tinit.getMechanisms();
            this.remoteMechs = rm;
            ASN1ObjectIdentifier prefMech = rm[0];
            if (this.mechContext.isSupported(prefMech)) {
                inputToken = tinit.getMechanismToken();
            } else {
                ASN1ObjectIdentifier found = null;
                for (ASN1ObjectIdentifier mech : rm) {
                    if (!this.mechContext.isSupported(mech)) continue;
                    found = mech;
                    break;
                }
                if (found == null) {
                    throw new SmbException("Server does advertise any supported mechanism");
                }
            }
        } else if (spToken instanceof NegTokenTarg) {
            targ = (NegTokenTarg)spToken;
            if (this.firstResponse) {
                if (!this.mechContext.isSupported(targ.getMechanism())) {
                    throw new SmbException("Server chose an unsupported mechanism " + targ.getMechanism());
                }
                this.selectedMech = targ.getMechanism();
                if (targ.getResult() == 3) {
                    this.requireMic = true;
                }
                this.firstResponse = false;
            } else if (targ.getMechanism() != null && !targ.getMechanism().equals((ASN1Primitive)this.selectedMech)) {
                throw new SmbException("Server switched mechanism");
            }
            inputToken = targ.getMechanismToken();
        } else {
            throw new SmbException("Invalid token");
        }
        if (spToken instanceof NegTokenTarg && this.mechContext.isEstablished()) {
            targ = (NegTokenTarg)spToken;
            if (targ.getResult() == 1 && targ.getMechanismToken() == null && targ.getMechanismListMIC() != null) {
                this.verifyMechListMIC(targ.getMechanismListMIC());
                return new NegTokenTarg(-1, null, null, this.calculateMechListMIC());
            }
            if (targ.getResult() != 0) {
                throw new SmbException("SPNEGO negotiation did not complete");
            }
            this.verifyMechListMIC(targ.getMechanismListMIC());
            this.completed = true;
            return null;
        }
        if (inputToken == null) {
            return this.initialToken();
        }
        byte[] mechMIC = null;
        byte[] responseToken = this.mechContext.initSecContext(inputToken, 0, inputToken.length);
        if (spToken instanceof NegTokenTarg) {
            NegTokenTarg targ2 = (NegTokenTarg)spToken;
            if (targ2.getResult() == 0 && this.mechContext.isEstablished()) {
                this.verifyMechListMIC(targ2.getMechanismListMIC());
                if (!this.disableMic || this.requireMic) {
                    mechMIC = this.calculateMechListMIC();
                }
                this.completed = true;
            } else if (this.mechContext.isMICAvailable() && (!this.disableMic || this.requireMic)) {
                mechMIC = this.calculateMechListMIC();
            } else if (targ2.getResult() == 2) {
                throw new SmbException("SPNEGO mechanism was rejected");
            }
        }
        if (responseToken == null && this.mechContext.isEstablished()) {
            return null;
        }
        return new NegTokenTarg(-1, null, responseToken, mechMIC);
    }

    private byte[] calculateMechListMIC() throws CIFSException {
        if (!this.mechContext.isMICAvailable()) {
            return null;
        }
        Object[] lm = this.mechs;
        byte[] ml = SpnegoContext.encodeMechs((ASN1ObjectIdentifier[])lm);
        byte[] mechanismListMIC = this.mechContext.calculateMIC(ml);
        if (log.isDebugEnabled()) {
            log.debug("Out Mech list " + Arrays.toString(lm));
            log.debug("Out Mech list encoded " + Hexdump.toHexString(ml));
            log.debug("Out Mech list MIC " + Hexdump.toHexString(mechanismListMIC));
        }
        return mechanismListMIC;
    }

    private void verifyMechListMIC(byte[] mechanismListMIC) throws CIFSException {
        if (this.disableMic) {
            return;
        }
        if (!(mechanismListMIC != null && this.mechContext.supportsIntegrity() || !this.requireMic || this.mechContext.isPreferredMech(this.selectedMech))) {
            throw new CIFSException("SPNEGO integrity is required but not available");
        }
        if (!this.mechContext.isMICAvailable() || mechanismListMIC == null) {
            return;
        }
        try {
            Object[] lm = this.mechs;
            byte[] ml = SpnegoContext.encodeMechs((ASN1ObjectIdentifier[])lm);
            if (log.isInfoEnabled()) {
                log.debug("In Mech list " + Arrays.toString(lm));
                log.debug("In Mech list encoded " + Hexdump.toHexString(ml));
                log.debug("In Mech list MIC " + Hexdump.toHexString(mechanismListMIC));
            }
            this.mechContext.verifyMIC(ml, mechanismListMIC);
        }
        catch (CIFSException e) {
            throw new CIFSException("Failed to verify mechanismListMIC", e);
        }
    }

    private static byte[] encodeMechs(ASN1ObjectIdentifier[] mechs) throws CIFSException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)bos);
            dos.writeObject((ASN1Primitive)new DERSequence((ASN1Encodable[])mechs));
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new CIFSException("Failed to encode mechList", e);
        }
    }

    private SpnegoToken initialToken() throws CIFSException {
        byte[] mechToken = this.mechContext.initSecContext(new byte[0], 0, 0);
        return new NegTokenInit(this.mechs, this.mechContext.getFlags(), mechToken, null);
    }

    @Override
    public boolean isEstablished() {
        return this.completed && this.mechContext.isEstablished();
    }

    private static SpnegoToken getToken(byte[] token, int off, int len) throws SpnegoException {
        byte[] b = new byte[len];
        if (off == 0 && token.length == len) {
            b = token;
        } else {
            System.arraycopy(token, off, b, 0, len);
        }
        return SpnegoContext.getToken(b);
    }

    private static SpnegoToken getToken(byte[] token) throws SpnegoException {
        SpnegoToken spnegoToken = null;
        try {
            switch (token[0]) {
                case 96: {
                    spnegoToken = new NegTokenInit(token);
                    break;
                }
                case -95: {
                    spnegoToken = new NegTokenTarg(token);
                    break;
                }
                default: {
                    throw new SpnegoException("Invalid token type");
                }
            }
            return spnegoToken;
        }
        catch (IOException e) {
            throw new SpnegoException("Invalid token");
        }
    }

    @Override
    public boolean supportsIntegrity() {
        return this.mechContext.supportsIntegrity();
    }

    @Override
    public boolean isPreferredMech(ASN1ObjectIdentifier mech) {
        return this.mechContext.isPreferredMech(mech);
    }

    @Override
    public byte[] calculateMIC(byte[] data) throws CIFSException {
        if (!this.completed) {
            throw new CIFSException("Context is not established");
        }
        return this.mechContext.calculateMIC(data);
    }

    @Override
    public void verifyMIC(byte[] data, byte[] mic) throws CIFSException {
        if (!this.completed) {
            throw new CIFSException("Context is not established");
        }
        this.mechContext.verifyMIC(data, mic);
    }

    @Override
    public boolean isMICAvailable() {
        if (!this.completed) {
            return false;
        }
        return this.mechContext.isMICAvailable();
    }

    public String toString() {
        return "SPNEGO[" + this.mechContext + "]";
    }

    @Override
    public void dispose() throws CIFSException {
        this.mechContext.dispose();
    }

    static {
        try {
            SPNEGO_MECH_OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.2");
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to initialize OID", (Throwable)e);
        }
    }
}

