/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.DfsReferralData;
import jcifs.RuntimeCIFSException;
import jcifs.SmbResourceLocator;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.RequestWithPath;
import jcifs.internal.dfs.DfsReferralDataInternal;
import jcifs.internal.smb1.com.SmbComClose;
import jcifs.smb.DfsReferral;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbResourceLocatorImpl;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbSessionInternal;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTransportInternal;
import jcifs.smb.SmbTreeConnectionTrace;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbTreeImpl;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTreeConnection {
    private static final Logger log = LoggerFactory.getLogger(SmbTreeConnection.class);
    private final CIFSContext ctx;
    private final SmbTreeConnection delegate;
    private SmbTreeImpl tree;
    private volatile boolean treeAcquired;
    private volatile boolean delegateAcquired;
    private SmbTransportInternal exclusiveTransport;
    private boolean nonPooled;
    private final AtomicLong usageCount = new AtomicLong();
    private static final Random RAND = new Random();

    protected SmbTreeConnection(CIFSContext ctx) {
        this.ctx = ctx;
        this.delegate = null;
    }

    protected SmbTreeConnection(SmbTreeConnection treeConnection) {
        this.ctx = treeConnection.ctx;
        this.delegate = treeConnection;
    }

    static SmbTreeConnection create(CIFSContext c) {
        if (c.getConfig().isTraceResourceUsage()) {
            return new SmbTreeConnectionTrace(c);
        }
        return new SmbTreeConnection(c);
    }

    static SmbTreeConnection create(SmbTreeConnection c) {
        if (c.ctx.getConfig().isTraceResourceUsage()) {
            return new SmbTreeConnectionTrace(c);
        }
        return new SmbTreeConnection(c);
    }

    public Configuration getConfig() {
        return this.ctx.getConfig();
    }

    private synchronized SmbTreeImpl getTree() {
        SmbTreeImpl t = this.tree;
        if (t != null) {
            return t.acquire(false);
        }
        if (this.delegate != null) {
            this.tree = this.delegate.getTree();
            return this.tree;
        }
        return t;
    }

    private synchronized SmbTreeImpl getTreeInternal() {
        SmbTreeImpl t = this.tree;
        if (t != null) {
            return t;
        }
        if (this.delegate != null) {
            return this.delegate.getTreeInternal();
        }
        return null;
    }

    private synchronized void switchTree(SmbTreeImpl t) {
        try (SmbTreeImpl old = this.getTree();){
            if (old == t) {
                return;
            }
            boolean wasAcquired = this.treeAcquired;
            log.debug("Switching tree");
            if (t != null) {
                log.debug("Acquired tree on switch " + t);
                t.acquire();
                this.treeAcquired = true;
            } else {
                this.treeAcquired = false;
            }
            this.tree = t;
            if (old != null && wasAcquired) {
                old.release(true);
            }
            if (this.delegate != null && this.delegateAcquired) {
                log.debug("Releasing delegate");
                this.delegateAcquired = false;
                this.delegate.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmbTreeConnection acquire() {
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Acquire tree connection " + usage + " " + this);
        }
        if (usage == 1L) {
            SmbTreeConnection smbTreeConnection = this;
            synchronized (smbTreeConnection) {
                try (SmbTreeImpl t = this.getTree();){
                    if (t != null && !this.treeAcquired) {
                        if (log.isDebugEnabled()) {
                            log.debug("Acquire tree on first usage " + t);
                        }
                        t.acquire();
                        this.treeAcquired = true;
                    }
                }
                if (this.delegate != null && !this.delegateAcquired) {
                    log.debug("Acquire delegate on first usage");
                    this.delegate.acquire();
                    this.delegateAcquired = true;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        long usage = this.usageCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Release tree connection " + usage + " " + this);
        }
        if (usage == 0L) {
            SmbTreeConnection smbTreeConnection = this;
            synchronized (smbTreeConnection) {
                try (SmbTreeImpl t = this.getTree();){
                    if (this.treeAcquired && t != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Tree connection no longer in use, release tree " + t);
                        }
                        this.treeAcquired = false;
                        t.release();
                    }
                }
                if (this.delegate != null && this.delegateAcquired) {
                    this.delegateAcquired = false;
                    this.delegate.release();
                }
            }
            SmbTransportInternal et = this.exclusiveTransport;
            if (et != null) {
                SmbTreeConnection smbTreeConnection2 = this;
                synchronized (smbTreeConnection2) {
                    try {
                        log.debug("Disconnecting exclusive transport");
                        this.exclusiveTransport = null;
                        this.tree = null;
                        this.treeAcquired = false;
                        et.close();
                        et.disconnect(false, false);
                    }
                    catch (Exception e) {
                        log.error("Failed to close exclusive transport", (Throwable)e);
                    }
                }
            }
        } else if (usage < 0L) {
            log.error("Usage count dropped below zero " + this);
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    protected void checkRelease() {
        if (this.isConnected() && this.usageCount.get() != 0L) {
            log.warn("Tree connection was not properly released " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect(boolean inError) {
        try (SmbSessionImpl session = this.getSession();){
            if (session == null) {
                return;
            }
            try (SmbTransportImpl transport = session.getTransport();){
                SmbTransportImpl smbTransportImpl = transport;
                synchronized (smbTransportImpl) {
                    SmbTreeImpl t = this.getTreeInternal();
                    if (t != null) {
                        try {
                            t.treeDisconnect(inError, true);
                        }
                        finally {
                            this.tree = null;
                            this.treeAcquired = false;
                        }
                    } else {
                        this.delegate.disconnect(inError);
                    }
                }
            }
        }
    }

    <T extends CommonServerMessageBlockResponse> T send(SmbResourceLocatorImpl loc, CommonServerMessageBlockRequest request, T response, RequestParam ... params) throws CIFSException {
        return this.send(loc, request, response, params.length == 0 ? EnumSet.noneOf(RequestParam.class) : EnumSet.copyOf(Arrays.asList(params)));
    }

    <T extends CommonServerMessageBlockResponse> T send(SmbResourceLocatorImpl loc, CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException {
        CIFSException last = null;
        RequestWithPath rpath = request instanceof RequestWithPath ? (RequestWithPath)((Object)request) : null;
        String savedPath = rpath != null ? rpath.getPath() : null;
        String savedFullPath = rpath != null ? rpath.getFullUNCPath() : null;
        String fullPath = "\\" + loc.getServer() + "\\" + loc.getShare() + loc.getUNCPath();
        int maxRetries = this.ctx.getConfig().getMaxRequestRetries();
        for (int retries = 1; retries <= maxRetries; ++retries) {
            if (rpath != null) {
                rpath.setFullUNCPath(null, null, fullPath);
            }
            try {
                return this.send0(loc, request, response, params);
            }
            catch (SmbException smbe) {
                if (params.contains((Object)RequestParam.NO_RETRY) || !(smbe.getCause() instanceof TransportException) && smbe.getNtStatus() != -1073741811) {
                    log.debug("Not retrying", (Throwable)smbe);
                    throw smbe;
                }
                log.debug("send", (Throwable)smbe);
                last = smbe;
            }
            catch (CIFSException e) {
                log.debug("send", (Throwable)e);
                last = e;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Retrying (%d/%d) request %s", retries, maxRetries, request));
            }
            log.debug("Disconnecting tree on send retry", (Throwable)last);
            this.disconnect(true);
            if (retries >= maxRetries) break;
            try {
                if (retries != 1) {
                    Thread.sleep(500 + RAND.nextInt(1000));
                }
            }
            catch (InterruptedException e) {
                log.debug("interrupted sleep in send", (Throwable)e);
            }
            if (request != null) {
                log.debug("Restting request");
                request.reset();
            }
            if (rpath != null) {
                rpath.setPath(savedPath);
                rpath.setFullUNCPath(rpath.getDomain(), rpath.getServer(), savedFullPath);
            }
            if (response != null) {
                response.reset();
            }
            try (SmbTreeHandleImpl th = this.connectWrapException(loc);){
                log.debug("Have new tree connection for retry");
                continue;
            }
            catch (SmbException e) {
                log.debug("Failed to connect tree on retry", (Throwable)e);
                last = e;
            }
        }
        if (last != null) {
            log.debug("All attempts have failed, last exception", last);
            throw last;
        }
        throw new SmbException("All attempts failed, but no exception");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends CommonServerMessageBlockResponse> T send0(SmbResourceLocatorImpl loc, CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException, DfsReferral {
        int limit = 10;
        while (limit > 0) {
            if (request instanceof RequestWithPath) {
                this.ensureDFSResolved(loc, (RequestWithPath)((Object)request));
            }
            try (SmbTreeImpl t2 = this.getTree();){
                if (t2 == null) {
                    throw new CIFSException("Failed to get tree connection");
                }
                T t = t2.send(request, response, params);
                return t;
            }
            catch (DfsReferral dre) {
                if (dre.getData().unwrap(DfsReferralDataInternal.class).isResolveHashes()) {
                    throw dre;
                }
                request.reset();
                log.trace("send0", (Throwable)dre);
                --limit;
            }
        }
        throw new CIFSException("Loop in DFS referrals");
    }

    public SmbTreeHandleImpl connectWrapException(SmbResourceLocatorImpl loc) throws SmbException {
        try {
            return this.connect(loc);
        }
        catch (UnknownHostException uhe) {
            throw new SmbException("Failed to connect to server", (Throwable)uhe);
        }
        catch (SmbException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SmbException("Failed to connect to server", (Throwable)ioe);
        }
    }

    public synchronized SmbTreeHandleImpl connect(SmbResourceLocatorImpl loc) throws IOException {
        try (SmbSessionImpl session = this.getSession();){
            SmbTreeHandleImpl smbTreeHandleImpl;
            if (this.isConnected()) {
                try (SmbTransportImpl transport = session.getTransport();){
                    if (transport.isDisconnected() || transport.getRemoteHostName() == null) {
                        log.debug("Disconnecting failed tree and session");
                        this.disconnect(true);
                    }
                }
            }
            if (this.isConnected()) {
                log.trace("Already connected");
                smbTreeHandleImpl = new SmbTreeHandleImpl(loc, this);
                return smbTreeHandleImpl;
            }
            smbTreeHandleImpl = this.connectHost(loc, loc.getServerWithDfs());
            return smbTreeHandleImpl;
        }
    }

    public synchronized boolean isConnected() {
        SmbTreeImpl t = this.getTreeInternal();
        return t != null && t.isConnected();
    }

    public synchronized SmbTreeHandleImpl connectHost(SmbResourceLocatorImpl loc, String host) throws IOException {
        return this.connectHost(loc, host, null);
    }

    /*
     * Exception decompiling
     */
    public synchronized SmbTreeHandleImpl connectHost(SmbResourceLocatorImpl loc, String host, DfsReferralData referral) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SmbTreeImpl connectTree(SmbResourceLocatorImpl loc, String addr, String share, SmbTransportInternal trans, SmbTreeImpl t, DfsReferralData referral) throws CIFSException {
        if (log.isDebugEnabled() && trans.isSigningOptional() && !loc.isIPC() && !this.ctx.getConfig().isSigningEnforced()) {
            log.debug("Signatures for file enabled but not required " + this);
        }
        if (referral != null) {
            t.markDomainDfs();
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("doConnect: " + addr);
            }
            t.treeConnect(null, null);
            return t.acquire();
        }
        catch (SmbAuthException sae) {
            log.debug("Authentication failed", (Throwable)sae);
            if (t.getSession().getCredentials().isAnonymous()) {
                try (SmbSessionInternal s = trans.getSmbSession(this.ctx.withAnonymousCredentials(), t.getSession().getTargetHost(), t.getSession().getTargetDomain()).unwrap(SmbSessionInternal.class);){
                    SmbTreeImpl tr = s.getSmbTree(null, null).unwrap(SmbTreeImpl.class);
                    try {
                        tr.treeConnect(null, null);
                        log.debug("Anonymous retry succeeded");
                        SmbTreeImpl smbTreeImpl = tr.acquire();
                        if (tr != null) {
                            tr.close();
                        }
                        return smbTreeImpl;
                    }
                    catch (Throwable throwable) {
                        if (tr != null) {
                            try {
                                tr.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.debug("Retry also failed", (Throwable)e);
                    throw sae;
                }
            }
            if (this.ctx.renewCredentials(loc.getURL().toString(), sae)) {
                log.debug("Trying to renew credentials after auth error");
                try (SmbSessionInternal s = trans.getSmbSession(this.ctx, t.getSession().getTargetHost(), t.getSession().getTargetDomain()).unwrap(SmbSessionInternal.class);){
                    SmbTreeImpl tr = s.getSmbTree(share, null).unwrap(SmbTreeImpl.class);
                    try {
                        if (referral != null) {
                            tr.markDomainDfs();
                        }
                        tr.treeConnect(null, null);
                        SmbTreeImpl smbTreeImpl = tr.acquire();
                        if (tr != null) {
                            tr.close();
                        }
                        return smbTreeImpl;
                    }
                    catch (Throwable throwable) {
                        if (tr != null) {
                            try {
                                tr.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            throw sae;
        }
    }

    SmbResourceLocator ensureDFSResolved(SmbResourceLocatorImpl loc) throws CIFSException {
        return this.ensureDFSResolved(loc, null);
    }

    SmbResourceLocator ensureDFSResolved(SmbResourceLocatorImpl loc, RequestWithPath request) throws CIFSException {
        if (request instanceof SmbComClose) {
            return loc;
        }
        for (int retries = 0; retries < 1 + this.ctx.getConfig().getMaxRequestRetries(); ++retries) {
            try {
                return this.resolveDfs0(loc, request);
            }
            catch (SmbException smbe) {
                if (smbe.getNtStatus() != -1073741275 && !(smbe.getCause() instanceof TransportException)) {
                    throw smbe;
                }
                log.debug("resolveDfs", (Throwable)smbe);
                if (log.isDebugEnabled()) {
                    log.debug("Retrying (" + retries + ") resolveDfs: " + request);
                }
                log.debug("Disconnecting tree on DFS retry");
                this.disconnect(true);
                try {
                    Thread.sleep(500 + RAND.nextInt(5000));
                }
                catch (InterruptedException e) {
                    log.debug("resolveDfs", (Throwable)e);
                }
                SmbTreeHandleImpl th = this.connectWrapException(loc);
                if (th == null) continue;
                th.close();
                continue;
            }
        }
        return loc;
    }

    /*
     * Exception decompiling
     */
    private SmbResourceLocator resolveDfs0(SmbResourceLocatorImpl loc, RequestWithPath request) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setNonPooled(boolean np) {
        this.nonPooled = np;
    }

    public long getTreeId() {
        SmbTreeImpl t = this.getTreeInternal();
        if (t == null) {
            return -1L;
        }
        return t.getTreeNum();
    }

    public SmbSessionImpl getSession() {
        SmbTreeImpl t = this.getTreeInternal();
        if (t != null) {
            return t.getSession();
        }
        return null;
    }

    public boolean hasCapability(int cap) throws SmbException {
        try (SmbSessionImpl s = this.getSession();){
            if (s != null) {
                try (SmbTransportImpl transport = s.getTransport();){
                    boolean bl = transport.hasCapability(cap);
                    return bl;
                }
            }
            throw new SmbException("Not connected");
        }
    }

    public int getTreeType() {
        try (SmbTreeImpl t = this.getTree();){
            int n = t.getTreeType();
            return n;
        }
    }

    public String getConnectedShare() {
        try (SmbTreeImpl t = this.getTree();){
            String string = t.getShare();
            return string;
        }
    }

    public boolean isSame(SmbTreeConnection other) {
        try (SmbTreeImpl t1 = this.getTree();){
            SmbTreeImpl t2 = other.getTree();
            try {
                boolean bl;
                boolean bl2 = bl = t1 == t2;
                if (t2 != null) {
                    t2.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (t2 != null) {
                    try {
                        t2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

