/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import jcifs.CIFSException;
import jcifs.smb.MIEName;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Kerb5Context
implements SSPContext {
    private static final Logger log;
    private static final ASN1ObjectIdentifier KRB5_MECH_OID;
    private static final ASN1ObjectIdentifier KRB5_MS_MECH_OID;
    static final ASN1ObjectIdentifier[] SUPPORTED_MECHS;
    private static final Oid JGSS_KRB5_NAME_OID;
    private static final Oid JGSS_KRB5_MECH_OID;
    private final GSSContext gssContext;
    private final GSSName clientName;
    private final GSSName serviceName;
    private static final String OPENJDK_JGSS_INQUIRE_TYPE_CLASS = "com.sun.security.jgss.InquireType";
    private static final String OPENJDK_JGSS_EXT_GSSCTX_CLASS = "com.sun.security.jgss.ExtendedGSSContext";
    private static final String IBM_JGSS_INQUIRE_TYPE_CLASS = "com.ibm.security.jgss.InquireType";
    private static final String IBM_JGSS_EXT_GSSCTX_CLASS = "com.ibm.security.jgss.ExtendedGSSContext";
    private static final Class<?> EXT_GSS_CONTEXT_CLASS;
    private static final Method INQUIRE_SEC_CONTEXT;
    private static final Object INQUIRE_TYPE_SESSION_KEY;

    Kerb5Context(String host, String service, String name, int userLifetime, int contextLifetime, String realm) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSCredential clientCreds = null;
        Oid mechOid = JGSS_KRB5_MECH_OID;
        this.serviceName = realm != null ? manager.createName(service + "/" + host + "@" + realm, JGSS_KRB5_NAME_OID, mechOid) : manager.createName(service + "@" + host, GSSName.NT_HOSTBASED_SERVICE, mechOid);
        if (log.isDebugEnabled()) {
            log.debug("Service name is " + this.serviceName);
        }
        if (name != null) {
            this.clientName = manager.createName(name, GSSName.NT_USER_NAME, mechOid);
            clientCreds = manager.createCredential(this.clientName, userLifetime, mechOid, 1);
        } else {
            this.clientName = null;
        }
        this.gssContext = manager.createContext(this.serviceName, mechOid, clientCreds, contextLifetime);
        this.gssContext.requestAnonymity(false);
        this.gssContext.requestSequenceDet(false);
        this.gssContext.requestConf(false);
        this.gssContext.requestInteg(false);
        this.gssContext.requestReplayDet(false);
        this.gssContext.requestMutualAuth(true);
        this.gssContext.requestCredDeleg(true);
    }

    @Override
    public boolean isSupported(ASN1ObjectIdentifier mechanism) {
        return KRB5_MECH_OID.equals((Object)mechanism) || KRB5_MS_MECH_OID.equals((Object)mechanism);
    }

    @Override
    public boolean isPreferredMech(ASN1ObjectIdentifier mechanism) {
        return this.isSupported(mechanism);
    }

    @Override
    public ASN1ObjectIdentifier[] getSupportedMechs() {
        return SUPPORTED_MECHS;
    }

    @Override
    public int getFlags() {
        int contextFlags = 0;
        if (this.gssContext.getCredDelegState()) {
            contextFlags |= 0x40;
        }
        if (this.gssContext.getMutualAuthState()) {
            contextFlags |= 0x20;
        }
        if (this.gssContext.getReplayDetState()) {
            contextFlags |= 0x10;
        }
        if (this.gssContext.getSequenceDetState()) {
            contextFlags |= 8;
        }
        if (this.gssContext.getAnonymityState()) {
            contextFlags |= 4;
        }
        if (this.gssContext.getConfState()) {
            contextFlags |= 2;
        }
        if (this.gssContext.getIntegState()) {
            contextFlags |= 1;
        }
        return contextFlags;
    }

    @Override
    public boolean isEstablished() {
        return this.gssContext != null && this.gssContext.isEstablished();
    }

    @Override
    public boolean supportsIntegrity() {
        return true;
    }

    @Override
    public byte[] calculateMIC(byte[] data) throws CIFSException {
        try {
            return this.gssContext.getMIC(data, 0, data.length, new MessageProp(false));
        }
        catch (GSSException e) {
            throw new CIFSException("Failed to calculate MIC", e);
        }
    }

    @Override
    public void verifyMIC(byte[] data, byte[] mic) throws CIFSException {
        try {
            this.gssContext.verifyMIC(mic, 0, mic.length, data, 0, data.length, new MessageProp(false));
        }
        catch (GSSException e) {
            throw new CIFSException("Failed to verify MIC", e);
        }
    }

    @Override
    public boolean isMICAvailable() {
        return this.gssContext.getIntegState();
    }

    @Override
    public String getNetbiosName() {
        return null;
    }

    @Override
    public byte[] getSigningKey() throws SmbException {
        if (EXT_GSS_CONTEXT_CLASS == null || INQUIRE_SEC_CONTEXT == null || INQUIRE_TYPE_SESSION_KEY == null) {
            throw new SmbException("ExtendedGSSContext support not available from JRE");
        }
        if (EXT_GSS_CONTEXT_CLASS.isAssignableFrom(this.gssContext.getClass())) {
            try {
                Key k = (Key)INQUIRE_SEC_CONTEXT.invoke((Object)this.gssContext, INQUIRE_TYPE_SESSION_KEY);
                return k.getEncoded();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new SmbException("Failed to query Kerberos session key from ExtendedGSSContext", (Throwable)ex);
            }
        }
        throw new SmbException("ExtendedGSSContext is not implemented by GSSContext");
    }

    @Override
    public byte[] initSecContext(byte[] token, int off, int len) throws SmbException {
        try {
            return this.gssContext.initSecContext(token, off, len);
        }
        catch (GSSException e) {
            throw new SmbException("GSSAPI mechanism failed", (Throwable)e);
        }
    }

    Key searchSessionKey(Subject subject) throws GSSException {
        MIEName src = new MIEName(this.gssContext.getSrcName().export());
        MIEName targ = new MIEName(this.gssContext.getTargName().export());
        ASN1ObjectIdentifier mech = ASN1ObjectIdentifier.getInstance((Object)this.gssContext.getMech().getDER());
        for (KerberosTicket ticket : subject.getPrivateCredentials(KerberosTicket.class)) {
            MIEName client = new MIEName(mech, ticket.getClient().getName());
            MIEName server = new MIEName(mech, ticket.getServer().getName());
            if (!src.equals(client) || !targ.equals(server)) continue;
            return ticket.getSessionKey();
        }
        return null;
    }

    public String toString() {
        if (this.gssContext == null || !this.gssContext.isEstablished()) {
            return String.format("KERB5[src=%s,targ=%s]", this.clientName, this.serviceName);
        }
        try {
            return String.format("KERB5[src=%s,targ=%s,mech=%s]", this.gssContext.getSrcName(), this.gssContext.getTargName(), this.gssContext.getMech());
        }
        catch (GSSException e) {
            log.debug("Failed to get info", (Throwable)e);
            return super.toString();
        }
    }

    @Override
    public void dispose() throws SmbException {
        if (this.gssContext != null) {
            try {
                this.gssContext.dispose();
            }
            catch (GSSException e) {
                throw new SmbException("Context disposal failed", (Throwable)e);
            }
        }
    }

    private static <T extends Enum<T>> Object getSessionKeyInquireType(Class<?> inquireTypeClass) {
        return Enum.valueOf(inquireTypeClass, "KRB5_GET_SESSION_KEY");
    }

    static {
        Object inquireTypeSessionKeyPrep;
        Method inquireSecContextPrep;
        Class<?> extendedGSSContextClassPrep;
        block9: {
            Class<?> inquireTypeClass;
            block8: {
                log = LoggerFactory.getLogger(Kerb5Context.class);
                KRB5_MECH_OID = new ASN1ObjectIdentifier("1.2.840.113554.1.2.2");
                KRB5_MS_MECH_OID = new ASN1ObjectIdentifier("1.2.840.48018.1.2.2");
                SUPPORTED_MECHS = new ASN1ObjectIdentifier[]{KRB5_MECH_OID, KRB5_MS_MECH_OID};
                Oid krbNameOid = null;
                Oid krbMechOid = null;
                try {
                    krbNameOid = new Oid("1.2.840.113554.1.2.2.1");
                    krbMechOid = new Oid("1.2.840.113554.1.2.2");
                }
                catch (Exception e) {
                    log.error("Failed to initialize kerberos OIDs", (Throwable)e);
                }
                JGSS_KRB5_NAME_OID = krbNameOid;
                JGSS_KRB5_MECH_OID = krbMechOid;
                extendedGSSContextClassPrep = null;
                inquireSecContextPrep = null;
                inquireTypeSessionKeyPrep = null;
                try {
                    extendedGSSContextClassPrep = Class.forName(OPENJDK_JGSS_EXT_GSSCTX_CLASS);
                    inquireTypeClass = Class.forName(OPENJDK_JGSS_INQUIRE_TYPE_CLASS);
                    inquireTypeSessionKeyPrep = Kerb5Context.getSessionKeyInquireType(inquireTypeClass);
                    inquireSecContextPrep = extendedGSSContextClassPrep.getMethod("inquireSecContext", inquireTypeClass);
                }
                catch (ClassNotFoundException | NoSuchMethodException | RuntimeException ex) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Failed to initalize ExtendedGSSContext initializdation for OracleJDK / OpenJDK", (Throwable)ex);
                }
            }
            if (extendedGSSContextClassPrep == null || inquireSecContextPrep == null || inquireTypeSessionKeyPrep == null) {
                try {
                    extendedGSSContextClassPrep = Class.forName(IBM_JGSS_EXT_GSSCTX_CLASS);
                    inquireTypeClass = Class.forName(IBM_JGSS_INQUIRE_TYPE_CLASS);
                    inquireTypeSessionKeyPrep = Kerb5Context.getSessionKeyInquireType(inquireTypeClass);
                    inquireSecContextPrep = extendedGSSContextClassPrep.getMethod("inquireSecContext", inquireTypeClass);
                }
                catch (ClassNotFoundException | NoSuchMethodException | RuntimeException ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Failed to initalize ExtendedGSSContext initializdation for IBM JDK", (Throwable)ex);
                }
            }
        }
        EXT_GSS_CONTEXT_CLASS = extendedGSSContextClassPrep;
        INQUIRE_SEC_CONTEXT = inquireSecContextPrep;
        INQUIRE_TYPE_SESSION_KEY = inquireTypeSessionKeyPrep;
        if (EXT_GSS_CONTEXT_CLASS != null && INQUIRE_SEC_CONTEXT != null && INQUIRE_TYPE_SESSION_KEY != null && log.isDebugEnabled()) {
            log.debug("Found ExtendedGSSContext implementation: " + EXT_GSS_CONTEXT_CLASS.getName());
        }
    }
}

