/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.util.Hexdump;

public class Type1Message
extends NtlmMessage {
    private String suppliedDomain;
    private String suppliedWorkstation;

    public Type1Message(CIFSContext tc) {
        this(tc, Type1Message.getDefaultFlags(tc), tc.getConfig().getDefaultDomain(), tc.getNameServiceClient().getLocalHost().getHostName());
    }

    public Type1Message(CIFSContext tc, int flags, String suppliedDomain, String suppliedWorkstation) {
        this.setFlags(Type1Message.getDefaultFlags(tc) | flags);
        this.setSuppliedDomain(suppliedDomain);
        if (suppliedWorkstation == null) {
            suppliedWorkstation = tc.getNameServiceClient().getLocalHost().getHostName();
        }
        this.setSuppliedWorkstation(suppliedWorkstation);
    }

    public Type1Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public static int getDefaultFlags(CIFSContext tc) {
        return 0x2000200 | (tc.getConfig().isUseUnicode() ? 1 : 2);
    }

    public String getSuppliedDomain() {
        return this.suppliedDomain;
    }

    public void setSuppliedDomain(String suppliedDomain) {
        this.suppliedDomain = suppliedDomain;
    }

    public String getSuppliedWorkstation() {
        return this.suppliedWorkstation;
    }

    public void setSuppliedWorkstation(String suppliedWorkstation) {
        this.suppliedWorkstation = suppliedWorkstation;
    }

    @Override
    public byte[] toByteArray() {
        try {
            int flags = this.getFlags();
            int size = 32 + ((flags & 0x2000000) != 0 ? 8 : 0);
            byte[] domain = new byte[]{};
            String suppliedDomainString = this.getSuppliedDomain();
            if ((flags & 0x2000000) == 0 && suppliedDomainString != null && suppliedDomainString.length() != 0) {
                flags |= 0x1000;
                domain = suppliedDomainString.toUpperCase().getBytes(Type1Message.getOEMEncoding());
                size += domain.length;
            } else {
                flags &= 0xFFFFEFFF;
            }
            byte[] workstation = new byte[]{};
            String suppliedWorkstationString = this.getSuppliedWorkstation();
            if ((flags & 0x2000000) == 0 && suppliedWorkstationString != null && suppliedWorkstationString.length() != 0) {
                flags |= 0x2000;
                workstation = suppliedWorkstationString.toUpperCase().getBytes(Type1Message.getOEMEncoding());
                size += workstation.length;
            } else {
                flags &= 0xFFFFDFFF;
            }
            byte[] type1 = new byte[size];
            int pos = 0;
            System.arraycopy(NTLMSSP_SIGNATURE, 0, type1, 0, NTLMSSP_SIGNATURE.length);
            Type1Message.writeULong(type1, pos += NTLMSSP_SIGNATURE.length, 1);
            Type1Message.writeULong(type1, pos += 4, flags);
            int domOffOff = Type1Message.writeSecurityBuffer(type1, pos += 4, domain);
            int wsOffOff = Type1Message.writeSecurityBuffer(type1, pos += 8, workstation);
            pos += 8;
            if ((flags & 0x2000000) != 0) {
                System.arraycopy(NTLMSSP_VERSION, 0, type1, pos, NTLMSSP_VERSION.length);
                pos += NTLMSSP_VERSION.length;
            }
            pos += Type1Message.writeSecurityBufferContent(type1, pos, domOffOff, domain);
            pos += Type1Message.writeSecurityBufferContent(type1, pos, wsOffOff, workstation);
            return type1;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        String suppliedDomainString = this.getSuppliedDomain();
        String suppliedWorkstationString = this.getSuppliedWorkstation();
        return "Type1Message[suppliedDomain=" + (suppliedDomainString == null ? "null" : suppliedDomainString) + ",suppliedWorkstation=" + (suppliedWorkstationString == null ? "null" : suppliedWorkstationString) + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    private void parse(byte[] material) throws IOException {
        int pos = 0;
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type1Message.readULong(material, pos += 8) != 1) {
            throw new IOException("Not a Type 1 message.");
        }
        int flags = Type1Message.readULong(material, pos += 4);
        this.setFlags(flags);
        pos += 4;
        if ((flags & 0x1000) != 0) {
            byte[] domain = Type1Message.readSecurityBuffer(material, pos);
            this.setSuppliedDomain(new String(domain, Type1Message.getOEMEncoding()));
        }
        pos += 8;
        if ((flags & 0x2000) != 0) {
            byte[] workstation = Type1Message.readSecurityBuffer(material, pos);
            this.setSuppliedWorkstation(new String(workstation, Type1Message.getOEMEncoding()));
        }
        pos += 8;
    }
}

