/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.text.Text;
import org.codelibs.elasticsearch.search.suggest.Suggest;

public class PhraseSuggestion
extends Suggest.Suggestion<Entry> {
    public static final int TYPE = 3;

    public PhraseSuggestion() {
    }

    public PhraseSuggestion(String name, int size) {
        super(name, size);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option> {
        protected double cutoffScore = Double.MIN_VALUE;

        public Entry(Text text, int offset, int length, double cutoffScore) {
            super(text, offset, length);
            this.cutoffScore = cutoffScore;
        }

        public Entry() {
        }

        public double getCutoffScore() {
            return this.cutoffScore;
        }

        @Override
        protected void merge(Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option> other) {
            super.merge(other);
            if (!(other instanceof Entry)) {
                return;
            }
            Entry otherSuggestionEntry = (Entry)other;
            this.cutoffScore = Math.max(this.cutoffScore, otherSuggestionEntry.cutoffScore);
        }

        @Override
        public void addOption(Suggest.Suggestion.Entry.Option option) {
            if ((double)option.getScore() > this.cutoffScore) {
                this.options.add(option);
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.cutoffScore = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.cutoffScore);
        }

        static class Fields {
            static final String CUTOFF_SCORE = "cutoff_score";

            Fields() {
            }
        }
    }
}

