/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion2x.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.common.xcontent.json.JsonXContent;

public abstract class ContextMapping
implements ToXContent {
    public static final char SEPARATOR = '\u001d';
    public static final SortedMap<String, ContextMapping> EMPTY_MAPPING = Collections.emptySortedMap();
    public static final SortedMap<String, ContextConfig> EMPTY_CONFIG = Collections.emptySortedMap();
    public static final Context EMPTY_CONTEXT = new Context(EMPTY_CONFIG);
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_MISSING = "default";
    public static final String FIELD_TYPE = "type";
    protected final String type;
    protected final String name;

    protected ContextMapping(String type, String name) {
        this.type = type;
        this.name = name;
    }

    protected String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(FIELD_TYPE, this.type);
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract ContextConfig defaultConfig();

    public abstract ContextQuery parseQuery(String var1, XContentParser var2) throws IOException, ElasticsearchParseException;

    protected abstract XContentBuilder toInnerXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public static boolean mappingsAreEqual(SortedMap<String, ? extends ContextMapping> thisMappings, SortedMap<String, ? extends ContextMapping> otherMappings) {
        return Objects.equals(thisMappings, otherMappings);
    }

    public String toString() {
        try {
            return this.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS).string();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public static abstract class ContextQuery
    implements ToXContent {
        protected final String name;

        protected ContextQuery(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public static Automaton toAutomaton(boolean preserveSep, Iterable<ContextQuery> queries) {
            Automaton a = Automata.makeEmptyString();
            Automaton gap = Automata.makeChar((int)29);
            if (preserveSep) {
                // empty if block
            }
            for (ContextQuery query : queries) {
                a = Operations.concatenate(Arrays.asList(query.toAutomaton(), gap, a));
            }
            return Operations.determinize((Automaton)a, (int)Integer.MAX_VALUE);
        }

        protected abstract Automaton toAutomaton();

        public static List<ContextQuery> parseQueries(Map<String, ContextMapping> mappings, XContentParser parser) throws IOException, ElasticsearchParseException {
            HashMap<String, ContextQuery> querySet = new HashMap<String, ContextQuery>();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    String name = parser.currentName();
                    ContextMapping mapping = mappings.get(name);
                    if (mapping == null) {
                        throw new ElasticsearchParseException("no mapping defined for [{}]", name);
                    }
                    parser.nextToken();
                    querySet.put(name, mapping.parseQuery(name, parser));
                }
            }
            ArrayList<ContextQuery> queries = new ArrayList<ContextQuery>(mappings.size());
            for (ContextMapping mapping : mappings.values()) {
                queries.add((ContextQuery)querySet.get(mapping.name));
            }
            return queries;
        }

        public String toString() {
            try {
                return this.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS).string();
            }
            catch (IOException e) {
                return super.toString();
            }
        }
    }

    public static abstract class ContextConfig {
    }

    public static class Context {
        final SortedMap<String, ContextConfig> contexts;

        public Context(SortedMap<String, ContextConfig> contexts) {
            this.contexts = contexts;
        }

        public TokenStream wrapTokenStream(TokenStream tokenStream) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
    }
}

