/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion2x.context;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.CategoryContextMapping;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.ContextMapping;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.GeolocationContextMapping;

public abstract class ContextBuilder<E extends ContextMapping> {
    protected String name;

    public ContextBuilder(String name) {
        this.name = name;
    }

    public abstract E build();

    public static GeolocationContextMapping.Builder location(String name) {
        return new GeolocationContextMapping.Builder(name);
    }

    public static GeolocationContextMapping.Builder location(String name, int precision, boolean neighbors) {
        return new GeolocationContextMapping.Builder(name, neighbors, precision);
    }

    public static CategoryContextMapping.Builder category(String name) {
        return new CategoryContextMapping.Builder(name, null);
    }

    public static CategoryContextMapping.Builder category(String name, String defaultCategory) {
        return new CategoryContextMapping.Builder(name, null).addDefaultValue(defaultCategory);
    }

    public static CategoryContextMapping.Builder reference(String name, String fieldname) {
        return new CategoryContextMapping.Builder(name, fieldname);
    }

    public static CategoryContextMapping.Builder reference(String name, String fieldname, Iterable<String> defaultValues) {
        return new CategoryContextMapping.Builder(name, fieldname).addDefaultValues(defaultValues);
    }

    public static SortedMap<String, ContextMapping> loadMappings(Object configuration, Version indexVersionCreated) throws ElasticsearchParseException {
        if (configuration instanceof Map) {
            Map configurations = (Map)configuration;
            TreeMap<String, ContextMapping> mappings = new TreeMap<String, ContextMapping>();
            for (Map.Entry config : configurations.entrySet()) {
                String name = (String)config.getKey();
                mappings.put(name, ContextBuilder.loadMapping(name, (Map)config.getValue(), indexVersionCreated));
            }
            return mappings;
        }
        if (configuration == null) {
            return ContextMapping.EMPTY_MAPPING;
        }
        throw new ElasticsearchParseException("no valid context configuration", new Object[0]);
    }

    protected static ContextMapping loadMapping(String name, Map<String, Object> config, Version indexVersionCreated) throws ElasticsearchParseException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }
}

