/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion2x;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.codelibs.elasticsearch.search.suggest.completion2x.Completion090PostingsFormat;
import org.codelibs.elasticsearch.search.suggest.completion2x.PayloadProcessor;

public class AnalyzingCompletionLookupProvider
extends Completion090PostingsFormat.CompletionLookupProvider {
    public static final int SERIALIZE_PRESERVE_SEPARATORS = 1;
    public static final int SERIALIZE_HAS_PAYLOADS = 2;
    public static final int SERIALIZE_PRESERVE_POSITION_INCREMENTS = 4;
    private static final int MAX_SURFACE_FORMS_PER_ANALYZED_FORM = 256;
    private static final int MAX_GRAPH_EXPANSIONS = -1;
    public static final String CODEC_NAME = "analyzing";
    public static final int CODEC_VERSION_START = 1;
    public static final int CODEC_VERSION_SERIALIZED_LABELS = 2;
    public static final int CODEC_VERSION_CHECKSUMS = 3;
    public static final int CODEC_VERSION_LATEST = 3;
    private final boolean preserveSep;
    private final boolean preservePositionIncrements;
    private final boolean hasPayloads;

    public AnalyzingCompletionLookupProvider(boolean preserveSep, boolean preservePositionIncrements, boolean hasPayloads) {
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.hasPayloads = hasPayloads;
        throw new UnsupportedOperationException("QueryBuilders does not support this operation.");
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    public boolean getPreserveSep() {
        return this.preserveSep;
    }

    public boolean getPreservePositionsIncrements() {
        return this.preservePositionIncrements;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Override
    public FieldsConsumer consumer(final IndexOutput output) throws IOException {
        CodecUtil.writeHeader((DataOutput)output, (String)CODEC_NAME, (int)3);
        return new FieldsConsumer(){
            private Map<String, Long> fieldOffsets = new HashMap<String, Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    long pointer = output.getFilePointer();
                    output.writeVInt(this.fieldOffsets.size());
                    for (Map.Entry<String, Long> entry : this.fieldOffsets.entrySet()) {
                        output.writeString(entry.getKey());
                        output.writeVLong(entry.getValue().longValue());
                    }
                    output.writeLong(pointer);
                    CodecUtil.writeFooter((IndexOutput)output);
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{output});
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{output});
            }

            public void write(Fields fields) throws IOException {
                for (String field : fields) {
                    Terms terms = fields.terms(field);
                    if (terms == null) continue;
                    terms.iterator();
                    new PayloadProcessor.SuggestPayload();
                    throw new UnsupportedOperationException("QueryBuilders does not support this operation.");
                }
            }
        };
    }

    @Override
    public Completion090PostingsFormat.LookupFactory load(IndexInput input) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IntsRef> toFiniteStrings(TokenStream stream) throws IOException {
        throw new UnsupportedOperationException("QueryBuilders does not support this operation.");
    }

    static class AnalyzingSuggestHolder
    implements Accountable {
        final boolean preserveSep;
        final boolean preservePositionIncrements;
        final int maxSurfaceFormsPerAnalyzedForm;
        final int maxGraphExpansions;
        final boolean hasPayloads;
        final int maxAnalyzedPathsForOneInput;
        final FST<PairOutputs.Pair<Long, BytesRef>> fst;
        final int sepLabel;
        final int payloadSep;
        final int endByte;
        final int holeCharacter;

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
            this.preserveSep = preserveSep;
            this.preservePositionIncrements = preservePositionIncrements;
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.maxGraphExpansions = maxGraphExpansions;
            this.hasPayloads = hasPayloads;
            this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
            this.fst = fst;
            this.sepLabel = sepLabel;
            this.payloadSep = payloadSep;
            this.endByte = endByte;
            this.holeCharacter = holeCharacter;
        }

        public boolean getPreserveSeparator() {
            return this.preserveSep;
        }

        public boolean getPreservePositionIncrements() {
            return this.preservePositionIncrements;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        public long ramBytesUsed() {
            if (this.fst != null) {
                return this.fst.ramBytesUsed();
            }
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            if (this.fst != null) {
                return Collections.singleton(Accountables.namedAccountable((String)"fst", this.fst));
            }
            return Collections.emptyList();
        }
    }
}

