/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codelibs.elasticsearch.common.geo.GeoHashUtils;
import org.codelibs.elasticsearch.common.geo.GeoPoint;
import org.codelibs.elasticsearch.common.geo.GeoUtils;
import org.codelibs.elasticsearch.common.unit.DistanceUnit;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.suggest.completion.context.ContextBuilder;
import org.codelibs.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.codelibs.elasticsearch.search.suggest.completion.context.GeoQueryContext;

public class GeoContextMapping
extends ContextMapping<GeoQueryContext> {
    public static final String FIELD_PRECISION = "precision";
    public static final String FIELD_FIELDNAME = "path";
    public static final int DEFAULT_PRECISION = 6;
    static final String CONTEXT_VALUE = "context";
    static final String CONTEXT_BOOST = "boost";
    static final String CONTEXT_PRECISION = "precision";
    static final String CONTEXT_NEIGHBOURS = "neighbours";
    private final int precision;
    private final String fieldName;

    private GeoContextMapping(String name, String fieldName, int precision) {
        super(ContextMapping.Type.GEO, name);
        this.precision = precision;
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getPrecision() {
        return this.precision;
    }

    protected static GeoContextMapping load(String name, Map<String, Object> config) {
        Builder builder = new Builder(name);
        if (config != null) {
            Object fieldName;
            Object configPrecision = config.get("precision");
            if (configPrecision != null) {
                if (configPrecision instanceof Integer) {
                    builder.precision((Integer)configPrecision);
                } else if (configPrecision instanceof Long) {
                    builder.precision(((Long)configPrecision).longValue());
                } else if (configPrecision instanceof Double) {
                    builder.precision((Double)configPrecision);
                } else if (configPrecision instanceof Float) {
                    builder.precision(((Float)configPrecision).floatValue());
                } else {
                    builder.precision(configPrecision.toString());
                }
                config.remove("precision");
            }
            if ((fieldName = config.get(FIELD_FIELDNAME)) != null) {
                builder.field(fieldName.toString());
                config.remove(FIELD_FIELDNAME);
            }
        }
        return builder.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("precision", this.precision);
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        return builder;
    }

    @Override
    protected GeoQueryContext fromXContent(QueryParseContext context) throws IOException {
        return GeoQueryContext.fromXContent(context);
    }

    @Override
    public List<ContextMapping.InternalQueryContext> toInternalQueryContexts(List<GeoQueryContext> queryContexts) {
        ArrayList<ContextMapping.InternalQueryContext> internalQueryContextList = new ArrayList<ContextMapping.InternalQueryContext>();
        for (GeoQueryContext queryContext : queryContexts) {
            int minPrecision = Math.min(this.precision, queryContext.getPrecision());
            GeoPoint point = queryContext.getGeoPoint();
            HashSet<String> locations = new HashSet<String>();
            String geoHash = GeoHashUtils.stringEncode(point.getLon(), point.getLat(), minPrecision);
            locations.add(geoHash);
            if (queryContext.getNeighbours().isEmpty() && geoHash.length() == this.precision) {
                GeoHashUtils.addNeighbors(geoHash, locations);
            } else if (!queryContext.getNeighbours().isEmpty()) {
                queryContext.getNeighbours().stream().filter(neighbourPrecision -> neighbourPrecision < geoHash.length()).forEach(neighbourPrecision -> {
                    String truncatedGeoHash = geoHash.substring(0, (int)neighbourPrecision);
                    locations.add(truncatedGeoHash);
                    GeoHashUtils.addNeighbors(truncatedGeoHash, locations);
                });
            }
            internalQueryContextList.addAll(locations.stream().map(location -> new ContextMapping.InternalQueryContext((String)location, queryContext.getBoost(), location.length() < this.precision)).collect(Collectors.toList()));
        }
        return internalQueryContextList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoContextMapping that = (GeoContextMapping)o;
        if (this.precision != that.precision) {
            return false;
        }
        return !(this.fieldName == null ? that.fieldName != null : !this.fieldName.equals(that.fieldName));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.fieldName);
    }

    public static class Builder
    extends ContextBuilder<GeoContextMapping> {
        private int precision = 6;
        private String fieldName = null;

        public Builder(String name) {
            super(name);
        }

        public Builder precision(String precision) {
            return this.precision(DistanceUnit.parse(precision, DistanceUnit.METERS, DistanceUnit.METERS));
        }

        public Builder precision(double precision, DistanceUnit unit) {
            return this.precision(unit.toMeters(precision));
        }

        public Builder precision(double meters) {
            int level = GeoUtils.geoHashLevelsForPrecision(meters);
            if (GeoUtils.geoHashCellSize(level) < meters) {
                level = Math.max(1, level - 1);
            }
            return this.precision(level);
        }

        public Builder precision(int level) {
            this.precision = level;
            return this;
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public GeoContextMapping build() {
            return new GeoContextMapping(this.name, this.fieldName, this.precision);
        }
    }
}

