/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.ContextQuery;
import org.apache.lucene.util.CharsRefBuilder;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.suggest.completion.context.ContextMapping;

public class ContextMappings
implements ToXContent {
    private final List<ContextMapping> contextMappings;
    private final Map<String, ContextMapping> contextNameMap;

    public ContextMappings(List<ContextMapping> contextMappings) {
        if (contextMappings.size() > 255) {
            throw new UnsupportedOperationException("Maximum of 10 context types are supported was: " + contextMappings.size());
        }
        this.contextMappings = contextMappings;
        this.contextNameMap = new HashMap<String, ContextMapping>(contextMappings.size());
        for (ContextMapping mapping : contextMappings) {
            this.contextNameMap.put(mapping.name(), mapping);
        }
    }

    public int size() {
        return this.contextMappings.size();
    }

    public ContextMapping get(String name) {
        ContextMapping contextMapping = this.contextNameMap.get(name);
        if (contextMapping == null) {
            throw new IllegalArgumentException("Unknown context name[" + name + "], must be one of " + this.contextNameMap.size());
        }
        return contextMapping;
    }

    public ContextQuery toContextQuery(CompletionQuery query, Map<String, List<ContextMapping.InternalQueryContext>> queryContexts) {
        ContextQuery typedContextQuery = new ContextQuery(query);
        if (!queryContexts.isEmpty()) {
            CharsRefBuilder scratch = new CharsRefBuilder();
            scratch.grow(1);
            for (int typeId = 0; typeId < this.contextMappings.size(); ++typeId) {
                scratch.setCharAt(0, (char)typeId);
                scratch.setLength(1);
                ContextMapping mapping = this.contextMappings.get(typeId);
                List<ContextMapping.InternalQueryContext> internalQueryContext = queryContexts.get(mapping.name());
                if (internalQueryContext == null) continue;
                for (ContextMapping.InternalQueryContext context : internalQueryContext) {
                    scratch.append((CharSequence)context.context);
                    typedContextQuery.addContext((CharSequence)scratch.toCharsRef(), (float)context.boost, !context.isPrefix);
                    scratch.setLength(1);
                }
            }
        }
        return typedContextQuery;
    }

    public Map<String, Set<CharSequence>> getNamedContexts(List<CharSequence> contexts) {
        HashMap<String, Set<CharSequence>> contextMap = new HashMap<String, Set<CharSequence>>(contexts.size());
        for (CharSequence typedContext : contexts) {
            char typeId = typedContext.charAt(0);
            assert (typeId < this.contextMappings.size()) : "Returned context has invalid type";
            ContextMapping mapping = this.contextMappings.get(typeId);
            HashSet<CharSequence> contextEntries = (HashSet<CharSequence>)contextMap.get(mapping.name());
            if (contextEntries == null) {
                contextEntries = new HashSet<CharSequence>();
                contextMap.put(mapping.name(), contextEntries);
            }
            contextEntries.add(typedContext.subSequence(1, typedContext.length()));
        }
        return contextMap;
    }

    public static ContextMappings load(Object configuration, Version indexVersionCreated) throws ElasticsearchParseException {
        ArrayList<ContextMapping> contextMappings;
        if (configuration instanceof List) {
            contextMappings = new ArrayList();
            List configurations = (List)configuration;
            for (Object contextConfig : configurations) {
                contextMappings.add(ContextMappings.load((Map)contextConfig, indexVersionCreated));
            }
            if (contextMappings.size() == 0) {
                throw new ElasticsearchParseException("expected at least one context mapping", new Object[0]);
            }
        } else if (configuration instanceof Map) {
            contextMappings = Collections.singletonList(ContextMappings.load((Map)configuration, indexVersionCreated));
        } else {
            throw new ElasticsearchParseException("expected a list or an entry of context mapping", new Object[0]);
        }
        return new ContextMappings(contextMappings);
    }

    private static ContextMapping load(Map<String, Object> contextConfig, Version indexVersionCreated) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (ContextMapping contextMapping : this.contextMappings) {
            builder.startObject();
            contextMapping.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.contextMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContextMappings)) {
            return false;
        }
        ContextMappings other = (ContextMappings)obj;
        return this.contextMappings.equals(other.contextMappings);
    }
}

