/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.Objects;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParseFieldMatcher;
import org.codelibs.elasticsearch.common.ParseFieldMatcherSupplier;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.QueryParseContext;

public final class CategoryQueryContext
implements ToXContent {
    public static final String NAME = "category";
    private final String category;
    private final boolean isPrefix;
    private final int boost;
    private static ObjectParser<Builder, ParseFieldMatcherSupplier> CATEGORY_PARSER = new ObjectParser("category", null);

    private CategoryQueryContext(String category, int boost, boolean isPrefix) {
        this.category = category;
        this.boost = boost;
        this.isPrefix = isPrefix;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public int getBoost() {
        return this.boost;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryQueryContext that = (CategoryQueryContext)o;
        if (this.isPrefix != that.isPrefix) {
            return false;
        }
        if (this.boost != that.boost) {
            return false;
        }
        return this.category != null ? this.category.equals(that.category) : that.category == null;
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.isPrefix ? 1 : 0);
        result = 31 * result + this.boost;
        return result;
    }

    public static CategoryQueryContext fromXContent(QueryParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        Builder builder = CategoryQueryContext.builder();
        if (token == XContentParser.Token.START_OBJECT) {
            CATEGORY_PARSER.parse(parser, builder, () -> ParseFieldMatcher.STRICT);
        } else if (token == XContentParser.Token.VALUE_STRING) {
            builder.setCategory(parser.text());
        } else {
            throw new ElasticsearchParseException("category context must be an object or string", new Object[0]);
        }
        return builder.build();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("context", this.category);
        builder.field("boost", this.boost);
        builder.field("prefix", this.isPrefix);
        builder.endObject();
        return builder;
    }

    static {
        CATEGORY_PARSER.declareString(Builder::setCategory, new ParseField("context", new String[0]));
        CATEGORY_PARSER.declareInt(Builder::setBoost, new ParseField("boost", new String[0]));
        CATEGORY_PARSER.declareBoolean(Builder::setPrefix, new ParseField("prefix", new String[0]));
    }

    public static class Builder {
        private String category;
        private boolean isPrefix = false;
        private int boost = 1;

        public Builder setCategory(String category) {
            Objects.requireNonNull(category, "category must not be null");
            this.category = category;
            return this;
        }

        public Builder setPrefix(boolean prefix) {
            this.isPrefix = prefix;
            return this;
        }

        public Builder setBoost(int boost) {
            if (boost <= 0) {
                throw new IllegalArgumentException("boost must be greater than 0");
            }
            this.boost = boost;
            return this;
        }

        public CategoryQueryContext build() {
            Objects.requireNonNull(this.category, "category must not be null");
            return new CategoryQueryContext(this.category, this.boost, this.isPrefix);
        }
    }
}

