/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import org.codelibs.elasticsearch.search.suggest.completion.context.ContextBuilder;
import org.codelibs.elasticsearch.search.suggest.completion.context.ContextMapping;

public class CategoryContextMapping
extends ContextMapping<CategoryQueryContext> {
    private static final String FIELD_FIELDNAME = "path";
    static final String CONTEXT_VALUE = "context";
    static final String CONTEXT_BOOST = "boost";
    static final String CONTEXT_PREFIX = "prefix";
    private final String fieldName;

    private CategoryContextMapping(String name, String fieldName) {
        super(ContextMapping.Type.CATEGORY, name);
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected static CategoryContextMapping load(String name, Map<String, Object> config) throws ElasticsearchParseException {
        Builder mapping = new Builder(name);
        Object fieldName = config.get(FIELD_FIELDNAME);
        if (fieldName != null) {
            mapping.field(fieldName.toString());
            config.remove(FIELD_FIELDNAME);
        }
        return mapping.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        return builder;
    }

    @Override
    protected CategoryQueryContext fromXContent(QueryParseContext context) throws IOException {
        return CategoryQueryContext.fromXContent(context);
    }

    @Override
    public List<ContextMapping.InternalQueryContext> toInternalQueryContexts(List<CategoryQueryContext> queryContexts) {
        ArrayList<ContextMapping.InternalQueryContext> internalInternalQueryContexts = new ArrayList<ContextMapping.InternalQueryContext>(queryContexts.size());
        internalInternalQueryContexts.addAll(queryContexts.stream().map(queryContext -> new ContextMapping.InternalQueryContext(queryContext.getCategory(), queryContext.getBoost(), queryContext.isPrefix())).collect(Collectors.toList()));
        return internalInternalQueryContexts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryContextMapping mapping = (CategoryContextMapping)o;
        return !(this.fieldName == null ? mapping.fieldName != null : !this.fieldName.equals(mapping.fieldName));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldName);
    }

    public static class Builder
    extends ContextBuilder<CategoryContextMapping> {
        private String fieldName;

        public Builder(String name) {
            super(name);
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public CategoryContextMapping build() {
            return new CategoryContextMapping(this.name, this.fieldName);
        }
    }
}

