/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParseFieldMatcherSupplier;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.unit.Fuzziness;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.common.xcontent.XContentType;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.suggest.SuggestionBuilder;
import org.codelibs.elasticsearch.search.suggest.SuggestionSearchContext;
import org.codelibs.elasticsearch.search.suggest.completion.FuzzyOptions;
import org.codelibs.elasticsearch.search.suggest.completion.RegexOptions;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.CategoryContextMapping;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.ContextMapping;
import org.codelibs.elasticsearch.search.suggest.completion2x.context.GeolocationContextMapping;

public class CompletionSuggestionBuilder
extends SuggestionBuilder<CompletionSuggestionBuilder> {
    static final String SUGGESTION_NAME = "completion";
    static final ParseField CONTEXTS_FIELD = new ParseField("contexts", "context");
    private static ObjectParser<InnerBuilder, ParseFieldMatcherSupplier> TLP_PARSER = new ObjectParser("completion", null);
    protected FuzzyOptions fuzzyOptions;
    protected RegexOptions regexOptions;
    protected BytesReference contextBytes = null;

    public CompletionSuggestionBuilder(String field) {
        super(field);
    }

    private CompletionSuggestionBuilder(String fieldname, CompletionSuggestionBuilder in) {
        super(fieldname, in);
        this.fuzzyOptions = in.fuzzyOptions;
        this.regexOptions = in.regexOptions;
        this.contextBytes = in.contextBytes;
    }

    public CompletionSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.fuzzyOptions = in.readOptionalWriteable(FuzzyOptions::new);
        this.regexOptions = in.readOptionalWriteable(RegexOptions::new);
        this.contextBytes = in.readOptionalBytesReference();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.fuzzyOptions);
        out.writeOptionalWriteable(this.regexOptions);
        out.writeOptionalBytesReference(this.contextBytes);
    }

    @Override
    public CompletionSuggestionBuilder prefix(String prefix) {
        super.prefix(prefix);
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, Fuzziness fuzziness) {
        super.prefix(prefix);
        this.fuzzyOptions = new FuzzyOptions.Builder().setFuzziness(fuzziness).build();
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, FuzzyOptions fuzzyOptions) {
        super.prefix(prefix);
        this.fuzzyOptions = fuzzyOptions;
        return this;
    }

    @Override
    public CompletionSuggestionBuilder regex(String regex) {
        super.regex(regex);
        return this;
    }

    public CompletionSuggestionBuilder regex(String regex, RegexOptions regexOptions) {
        this.regex(regex);
        this.regexOptions = regexOptions;
        return this;
    }

    public CompletionSuggestionBuilder contexts(Map<String, List<? extends ToXContent>> queryContexts) {
        Objects.requireNonNull(queryContexts, "contexts must not be null");
        try {
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            contentBuilder.startObject();
            for (Map.Entry<String, List<? extends ToXContent>> contextEntry : queryContexts.entrySet()) {
                contentBuilder.startArray(contextEntry.getKey());
                for (ToXContent toXContent : contextEntry.getValue()) {
                    toXContent.toXContent(contentBuilder, EMPTY_PARAMS);
                }
                contentBuilder.endArray();
            }
            contentBuilder.endObject();
            return this.contexts(contentBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CompletionSuggestionBuilder contexts(XContentBuilder contextBuilder) {
        this.contextBytes = contextBuilder.bytes();
        return this;
    }

    public CompletionSuggestionBuilder contexts(Contexts2x contexts2x) {
        Objects.requireNonNull(contexts2x, "contexts must not be null");
        try {
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            contentBuilder.startObject();
            for (ContextMapping.ContextQuery contextQuery : contexts2x.contextQueries) {
                contextQuery.toXContent(contentBuilder, EMPTY_PARAMS);
            }
            contentBuilder.endObject();
            return this.contexts(contentBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fuzzyOptions != null) {
            this.fuzzyOptions.toXContent(builder, params);
        }
        if (this.regexOptions != null) {
            this.regexOptions.toXContent(builder, params);
        }
        if (this.contextBytes != null) {
            builder.rawField(CONTEXTS_FIELD.getPreferredName(), this.contextBytes);
        }
        return builder;
    }

    static CompletionSuggestionBuilder innerFromXContent(QueryParseContext parseContext) throws IOException {
        InnerBuilder builder = new InnerBuilder();
        TLP_PARSER.parse(parseContext.parser(), builder, parseContext);
        String field = builder.field;
        if (field == null) {
            throw new ElasticsearchParseException("the required field option [" + FIELDNAME_FIELD.getPreferredName() + "] is missing", new Object[0]);
        }
        return new CompletionSuggestionBuilder(field, builder);
    }

    @Override
    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    @Override
    protected boolean doEquals(CompletionSuggestionBuilder other) {
        return Objects.equals(this.fuzzyOptions, other.fuzzyOptions) && Objects.equals(this.regexOptions, other.regexOptions) && Objects.equals(this.contextBytes, other.contextBytes);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fuzzyOptions, this.regexOptions, this.contextBytes);
    }

    static {
        TLP_PARSER.declareField((parser, completionSuggestionContext, context) -> {
            if (parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (parser.booleanValue()) {
                    completionSuggestionContext.fuzzyOptions = new FuzzyOptions.Builder().build();
                }
            } else {
                completionSuggestionContext.fuzzyOptions = FuzzyOptions.parse(parser, context);
            }
        }, FuzzyOptions.FUZZY_OPTIONS, ObjectParser.ValueType.OBJECT_OR_BOOLEAN);
        TLP_PARSER.declareField((parser, completionSuggestionContext, context) -> {
            completionSuggestionContext.regexOptions = RegexOptions.parse(parser, context);
        }, RegexOptions.REGEX_OPTIONS, ObjectParser.ValueType.OBJECT);
        TLP_PARSER.declareString((rec$, x$0) -> ((InnerBuilder)rec$).field(x$0), FIELDNAME_FIELD);
        TLP_PARSER.declareString(SuggestionBuilder::analyzer, ANALYZER_FIELD);
        TLP_PARSER.declareInt(SuggestionBuilder::size, SIZE_FIELD);
        TLP_PARSER.declareInt(SuggestionBuilder::shardSize, SHARDSIZE_FIELD);
        TLP_PARSER.declareField((p, v, c) -> {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.copyCurrentStructure(p);
            v.contextBytes = builder.bytes();
            p.skipChildren();
        }, CONTEXTS_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static class InnerBuilder
    extends CompletionSuggestionBuilder {
        private String field;

        public InnerBuilder() {
            super("_na_");
        }

        private InnerBuilder field(String field) {
            this.field = field;
            return this;
        }
    }

    public static class Contexts2x {
        private List<ContextMapping.ContextQuery> contextQueries = new ArrayList<ContextMapping.ContextQuery>();

        private Contexts2x addContextQuery(ContextMapping.ContextQuery ctx) {
            this.contextQueries.add(ctx);
            return this;
        }

        @Deprecated
        public Contexts2x addGeoLocation(String name, double lat, double lon, int ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        @Deprecated
        public Contexts2x addGeoLocationWithPrecision(String name, double lat, double lon, String ... precisions) {
            return this.addContextQuery(GeolocationContextMapping.query(name, lat, lon, precisions));
        }

        @Deprecated
        public Contexts2x addGeoLocation(String name, String geohash) {
            return this.addContextQuery(GeolocationContextMapping.query(name, geohash, new int[0]));
        }

        @Deprecated
        public Contexts2x addCategory(String name, CharSequence ... categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        @Deprecated
        public Contexts2x addCategory(String name, Iterable<? extends CharSequence> categories) {
            return this.addContextQuery(CategoryContextMapping.query(name, categories));
        }

        @Deprecated
        public Contexts2x addContextField(String name, CharSequence ... fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }

        @Deprecated
        public Contexts2x addContextField(String name, Iterable<? extends CharSequence> fieldvalues) {
            return this.addContextQuery(CategoryContextMapping.query(name, fieldvalues));
        }
    }
}

