/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.PriorityQueue;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.text.Text;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.suggest.Suggest;

public final class CompletionSuggestion
extends Suggest.Suggestion<Entry> {
    public static final int TYPE = 4;

    public CompletionSuggestion() {
    }

    public CompletionSuggestion(String name, int size) {
        super(name, size);
    }

    public List<Entry.Option> getOptions() {
        if (!this.entries.isEmpty()) {
            assert (this.entries.size() == 1) : "CompletionSuggestion must have only one entry";
            return ((Entry)this.entries.get(0)).getOptions();
        }
        return Collections.emptyList();
    }

    public boolean hasScoreDocs() {
        return this.getOptions().size() > 0;
    }

    public static CompletionSuggestion reduceTo(List<Suggest.Suggestion<Entry>> toReduce) {
        if (toReduce.isEmpty()) {
            return null;
        }
        CompletionSuggestion leader = (CompletionSuggestion)toReduce.get(0);
        Entry leaderEntry = (Entry)leader.getEntries().get(0);
        String name = leader.getName();
        if (toReduce.size() == 1) {
            return leader;
        }
        OptionPriorityQueue priorityQueue = new OptionPriorityQueue(leader.getSize(), Suggest.COMPARATOR);
        for (Suggest.Suggestion<Entry> suggestion : toReduce) {
            assert (suggestion.getName().equals(name)) : "name should be identical across all suggestions";
            for (Entry.Option option : ((CompletionSuggestion)suggestion).getOptions()) {
                if (option == priorityQueue.insertWithOverflow(option)) break;
            }
        }
        CompletionSuggestion suggestion = new CompletionSuggestion(leader.getName(), leader.getSize());
        Entry entry = new Entry(leaderEntry.getText(), leaderEntry.getOffset(), leaderEntry.getLength());
        Collections.addAll(entry.getOptions(), priorityQueue.get());
        suggestion.addTerm(entry);
        return suggestion;
    }

    @Override
    public Suggest.Suggestion<Entry> reduce(List<Suggest.Suggestion<Entry>> toReduce) {
        return CompletionSuggestion.reduceTo(toReduce);
    }

    public void setShardIndex(int shardIndex) {
        if (!this.entries.isEmpty()) {
            for (Entry.Option option : this.getOptions()) {
                option.setShardIndex(shardIndex);
            }
        }
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static final class Entry
    extends Suggest.Suggestion.Entry<Option> {
        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        protected Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private Map<String, Set<CharSequence>> contexts;
            private ScoreDoc doc;

            public Option(int docID, Text text, float score, Map<String, Set<CharSequence>> contexts) {
                super(text, score);
                this.doc = new ScoreDoc(docID, score);
                this.contexts = contexts;
            }

            protected Option() {
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Set<CharSequence>> getContexts() {
                return this.contexts;
            }

            public ScoreDoc getDoc() {
                return this.doc;
            }

            public void setShardIndex(int shardIndex) {
                this.doc.shardIndex = shardIndex;
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                throw new UnsupportedOperationException("querybuilders does not support this operation.");
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                throw new UnsupportedOperationException("querybuilders does not support this operation.");
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                throw new UnsupportedOperationException("querybuilders does not support this operation.");
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("text:");
                stringBuilder.append(this.getText());
                stringBuilder.append(" score:");
                stringBuilder.append(this.getScore());
                stringBuilder.append(" context:[");
                for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        }
    }

    private static final class OptionPriorityQueue
    extends PriorityQueue<Entry.Option> {
        private final Comparator<Suggest.Suggestion.Entry.Option> comparator;

        OptionPriorityQueue(int maxSize, Comparator<Suggest.Suggestion.Entry.Option> comparator) {
            super(maxSize);
            this.comparator = comparator;
        }

        protected boolean lessThan(Entry.Option a, Entry.Option b) {
            int cmp = this.comparator.compare(a, b);
            if (cmp != 0) {
                return cmp > 0;
            }
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(a.getText().string(), b.getText().string()) > 0;
        }

        Entry.Option[] get() {
            int size = this.size();
            Entry.Option[] results = new Entry.Option[size];
            for (int i = size - 1; i >= 0; --i) {
                results[i] = (Entry.Option)this.pop();
            }
            return results;
        }
    }
}

