/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;

public enum SortOrder implements Writeable
{
    ASC{

        public String toString() {
            return "asc";
        }
    }
    ,
    DESC{

        public String toString() {
            return "desc";
        }
    };


    static SortOrder readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= SortOrder.values().length) {
            throw new IOException("Unknown SortOrder ordinal [" + ordinal + "]");
        }
        return SortOrder.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static SortOrder fromString(String op) {
        return SortOrder.valueOf(op.toUpperCase(Locale.ROOT));
    }
}

