/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.codelibs.elasticsearch.action.support.ToXContentToBytes;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.NamedWriteable;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.query.QueryBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.sort.FieldSortBuilder;
import org.codelibs.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.codelibs.elasticsearch.search.sort.ScoreSortBuilder;
import org.codelibs.elasticsearch.search.sort.ScriptSortBuilder;
import org.codelibs.elasticsearch.search.sort.SortAndFormats;
import org.codelibs.elasticsearch.search.sort.SortFieldAndFormat;
import org.codelibs.elasticsearch.search.sort.SortOrder;

public abstract class SortBuilder<T extends SortBuilder<T>>
extends ToXContentToBytes
implements NamedWriteable {
    protected SortOrder order = SortOrder.ASC;
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField NESTED_FILTER_FIELD = new ParseField("nested_filter", new String[0]);
    public static final ParseField NESTED_PATH_FIELD = new ParseField("nested_path", new String[0]);
    private static final Map<String, Parser<?>> PARSERS;

    protected abstract SortFieldAndFormat build(QueryShardContext var1) throws IOException;

    public T order(SortOrder order) {
        Objects.requireNonNull(order, "sort order cannot be null.");
        this.order = order;
        return (T)this;
    }

    public SortOrder order() {
        return this.order;
    }

    public static List<SortBuilder<?>> fromXContent(QueryParseContext context) throws IOException {
        ArrayList sortFields = new ArrayList(2);
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    SortBuilder.parseCompoundSortField(context, sortFields);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String fieldName = parser.text();
                    sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
                    continue;
                }
                throw new IllegalArgumentException("malformed sort format, within the sort array, an object, or an actual string are allowed");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            String fieldName = parser.text();
            sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
        } else if (token == XContentParser.Token.START_OBJECT) {
            SortBuilder.parseCompoundSortField(context, sortFields);
        } else {
            throw new IllegalArgumentException("malformed sort format, either start with array, object, or an actual string");
        }
        return sortFields;
    }

    private static SortBuilder<?> fieldOrScoreSort(String fieldName) {
        if (fieldName.equals("_score")) {
            return new ScoreSortBuilder();
        }
        return new FieldSortBuilder(fieldName);
    }

    private static void parseCompoundSortField(QueryParseContext context, List<SortBuilder<?>> sortFields) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                SortOrder order = SortOrder.fromString(parser.text());
                sortFields.add((SortBuilder<?>)SortBuilder.fieldOrScoreSort(fieldName).order(order));
                continue;
            }
            if (PARSERS.containsKey(fieldName)) {
                sortFields.add((SortBuilder<?>)PARSERS.get(fieldName).fromXContent(context, fieldName));
                continue;
            }
            sortFields.add(FieldSortBuilder.fromXContent(context, fieldName));
        }
    }

    public static Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders, QueryShardContext context) throws IOException {
        SortField sortField;
        boolean sort;
        ArrayList<SortField> sortFields = new ArrayList<SortField>(sortBuilders.size());
        ArrayList<DocValueFormat> sortFormats = new ArrayList<DocValueFormat>(sortBuilders.size());
        for (SortBuilder<?> builder : sortBuilders) {
            SortFieldAndFormat sf = builder.build(context);
            sortFields.add(sf.field);
            sortFormats.add(sf.format);
        }
        if (!sortFields.isEmpty() && (sort = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != SortField.Type.SCORE || sortField.getReverse())) {
            return Optional.of(new SortAndFormats(new Sort(sortFields.toArray(new SortField[sortFields.size()])), sortFormats.toArray(new DocValueFormat[sortFormats.size()])));
        }
        return Optional.empty();
    }

    protected static IndexFieldData.XFieldComparatorSource.Nested resolveNested(QueryShardContext context, String nestedPath, QueryBuilder nestedFilter) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    protected static QueryBuilder parseNestedFilter(XContentParser parser, QueryParseContext context) {
        try {
            QueryBuilder builder = context.parseInnerQueryBuilder().orElseThrow(() -> new ParsingException(parser.getTokenLocation(), "Expected " + NESTED_FILTER_FIELD.getPreferredName() + " element.", new Object[0]));
            return builder;
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Expected " + NESTED_FILTER_FIELD.getPreferredName() + " element.", e, new Object[0]);
        }
    }

    static {
        HashMap<String, Parser<SortBuilder>> parsers = new HashMap<String, Parser<SortBuilder>>();
        parsers.put("_script", ScriptSortBuilder::fromXContent);
        parsers.put("_geo_distance", GeoDistanceSortBuilder::fromXContent);
        parsers.put("_geoDistance", GeoDistanceSortBuilder::fromXContent);
        parsers.put("_score", ScoreSortBuilder::fromXContent);
        PARSERS = Collections.unmodifiableMap(parsers);
    }

    @FunctionalInterface
    private static interface Parser<T extends SortBuilder<?>> {
        public T fromXContent(QueryParseContext var1, String var2) throws IOException;
    }
}

