/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.codelibs.elasticsearch.search.sort.SortBuilder;
import org.codelibs.elasticsearch.search.sort.SortFieldAndFormat;
import org.codelibs.elasticsearch.search.sort.SortOrder;

public class ScoreSortBuilder
extends SortBuilder<ScoreSortBuilder> {
    public static final String NAME = "_score";
    private static final SortFieldAndFormat SORT_SCORE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_SCORE_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE, true), DocValueFormat.RAW);
    private static ObjectParser<ScoreSortBuilder, QueryParseContext> PARSER = new ObjectParser("_score", ScoreSortBuilder::new);

    public ScoreSortBuilder() {
        this.order(SortOrder.DESC);
    }

    public ScoreSortBuilder(StreamInput in) throws IOException {
        this.order(SortOrder.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScoreSortBuilder fromXContent(QueryParseContext context, String fieldName) throws IOException {
        return PARSER.apply(context.parser(), context);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) {
        if (this.order == SortOrder.DESC) {
            return SORT_SCORE;
        }
        return SORT_SCORE_REVERSE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScoreSortBuilder other = (ScoreSortBuilder)object;
        return Objects.equals(this.order, other.order);
    }

    public int hashCode() {
        return Objects.hash(this.order);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareString((builder, order) -> {
            ScoreSortBuilder cfr_ignored_0 = (ScoreSortBuilder)builder.order(SortOrder.fromString(order));
        }, ORDER_FIELD);
    }
}

