/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.slice;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;
import org.codelibs.elasticsearch.search.slice.SliceQuery;

public final class TermsSliceQuery
extends SliceQuery {
    public TermsSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet disi = TermsSliceQuery.this.build(context.reader());
                DocIdSetIterator leafIt = disi.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), leafIt);
            }
        };
    }

    private DocIdSet build(LeafReader reader) throws IOException {
        DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc());
        Terms terms = reader.terms(this.getField());
        TermsEnum te = terms.iterator();
        PostingsEnum docsEnum = null;
        BytesRef term = te.next();
        while (term != null) {
            int hashCode = term.hashCode();
            if (this.contains(hashCode)) {
                docsEnum = te.postings(docsEnum, 0);
                builder.add((DocIdSetIterator)docsEnum);
            }
            term = te.next();
        }
        return builder.build();
    }
}

