/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.slice;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.action.support.ToXContentToBytes;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.Strings;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class SliceBuilder
extends ToXContentToBytes
implements Writeable {
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ObjectParser<SliceBuilder, QueryParseContext> PARSER = new ObjectParser("slice", SliceBuilder::new);
    private String field = "_uid";
    private int id = -1;
    private int max = -1;

    private SliceBuilder() {
    }

    public SliceBuilder(int id, int max) {
        this("_uid", id, max);
    }

    public SliceBuilder(String field, int id, int max) {
        this.setField(field);
        this.setId(id);
        this.setMax(max);
    }

    public SliceBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.id = in.readVInt();
        this.max = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeVInt(this.id);
        out.writeVInt(this.max);
    }

    private SliceBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    private SliceBuilder setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be greater than or equal to 0");
        }
        if (this.max != -1 && id >= this.max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    private SliceBuilder setMax(int max) {
        if (max <= 1) {
            throw new IllegalArgumentException("max must be greater than 1");
        }
        if (this.id != -1 && this.id >= max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(MAX_FIELD.getPreferredName(), this.max);
    }

    public static SliceBuilder fromXContent(QueryParseContext context) throws IOException {
        SliceBuilder builder = PARSER.parse(context.parser(), new SliceBuilder(), context);
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SliceBuilder)) {
            return false;
        }
        SliceBuilder o = (SliceBuilder)other;
        return (this.field == null && o.field == null || this.field.equals(o.field)) && this.id == o.id && o.max == this.max;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.id, this.max);
    }

    public Query toFilter(QueryShardContext context, int shardId, int numShards) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    static {
        PARSER.declareString(SliceBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(SliceBuilder::setId, ID_FIELD);
        PARSER.declareInt(SliceBuilder::setMax, MAX_FIELD);
    }
}

