/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.codelibs.elasticsearch.search.internal.SearchContext;
import org.codelibs.elasticsearch.search.rescore.QueryRescoreMode;
import org.codelibs.elasticsearch.search.rescore.RescoreSearchContext;
import org.codelibs.elasticsearch.search.rescore.Rescorer;

public final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    public static final String NAME = "query";
    private static final Comparator<ScoreDoc> SCORE_DOC_COMPARATOR = (o1, o2) -> {
        int cmp = Float.compare(o2.score, o1.score);
        return cmp == 0 ? Integer.compare(o1.doc, o2.doc) : cmp;
    };

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public TopDocs rescore(TopDocs topDocs, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public Explanation explain(int topLevelDocId, SearchContext context, RescoreSearchContext rescoreContext, Explanation sourceExplanation) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    public void extractTerms(SearchContext context, RescoreSearchContext rescoreContext, Set<Term> termsSet) {
        throw new UnsupportedOperationException();
    }

    public static class QueryRescoreContext
    extends RescoreSearchContext {
        static final int DEFAULT_WINDOW_SIZE = 10;
        private Query query;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;
        private QueryRescoreMode scoreMode = QueryRescoreMode.Total;

        public QueryRescoreContext(QueryRescorer rescorer) {
            super(QueryRescorer.NAME, 10, rescorer);
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public Query query() {
            return this.query;
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public QueryRescoreMode scoreMode() {
            return this.scoreMode;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        public void setScoreMode(QueryRescoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }

        public void setScoreMode(String scoreMode) {
            this.setScoreMode(QueryRescoreMode.fromString(scoreMode));
        }
    }
}

