/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.profile.ProfileResult;

public final class AggregationProfileShardResult
implements Writeable,
ToXContent {
    private final List<ProfileResult> aggProfileResults;

    public AggregationProfileShardResult(List<ProfileResult> aggProfileResults) {
        this.aggProfileResults = aggProfileResults;
    }

    public AggregationProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.aggProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.aggProfileResults.add(new ProfileResult(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggProfileResults.size());
        for (ProfileResult p : this.aggProfileResults) {
            p.writeTo(out);
        }
    }

    public List<ProfileResult> getProfileResults() {
        return Collections.unmodifiableList(this.aggProfileResults);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("aggregations");
        for (ProfileResult p : this.aggProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

