/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.search.profile.ProfileShardResult;
import org.codelibs.elasticsearch.search.profile.query.QueryProfileShardResult;

public final class SearchProfileShardResults
implements Writeable,
ToXContent {
    private Map<String, ProfileShardResult> shardResults;

    public SearchProfileShardResults(Map<String, ProfileShardResult> shardResults) {
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public SearchProfileShardResults(StreamInput in) throws IOException {
        int size = in.readInt();
        this.shardResults = new HashMap<String, ProfileShardResult>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            ProfileShardResult shardResult = new ProfileShardResult(in);
            this.shardResults.put(key, shardResult);
        }
        this.shardResults = Collections.unmodifiableMap(this.shardResults);
    }

    public Map<String, ProfileShardResult> getShardResults() {
        return this.shardResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardResults.size());
        for (Map.Entry<String, ProfileShardResult> entry : this.shardResults.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("profile").startArray("shards");
        for (Map.Entry<String, ProfileShardResult> entry : this.shardResults.entrySet()) {
            builder.startObject();
            builder.field("id", entry.getKey());
            builder.startArray("searches");
            for (QueryProfileShardResult result : entry.getValue().getQueryProfileResults()) {
                builder.startObject();
                result.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            entry.getValue().getAggregationProfileResults().toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray().endObject();
        return builder;
    }
}

