/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProfileBreakdown<T extends Enum<T>> {
    private final long[] timings;
    private final long[] counts;
    private T currentTimingType;
    private long scratch;
    private T[] timingTypes;

    public AbstractProfileBreakdown(T[] timingTypes) {
        this.timingTypes = timingTypes;
        this.timings = new long[timingTypes.length];
        this.counts = new long[timingTypes.length];
    }

    public void startTime(T timing) {
        assert (this.currentTimingType == null);
        assert (this.scratch == 0L);
        int n = ((Enum)timing).ordinal();
        this.counts[n] = this.counts[n] + 1L;
        this.currentTimingType = timing;
        this.scratch = System.nanoTime();
    }

    public long stopAndRecordTime() {
        long time = Math.max(1L, System.nanoTime() - this.scratch);
        int n = ((Enum)this.currentTimingType).ordinal();
        this.timings[n] = this.timings[n] + time;
        this.currentTimingType = null;
        this.scratch = 0L;
        return time;
    }

    public Map<String, Long> toTimingMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (T timingType : this.timingTypes) {
            map.put(((Enum)timingType).toString(), this.timings[((Enum)timingType).ordinal()]);
            map.put(((Enum)timingType).toString() + "_count", this.counts[((Enum)timingType).ordinal()]);
        }
        return Collections.unmodifiableMap(map);
    }

    public void merge(AbstractProfileBreakdown<T> other) {
        int i;
        assert (this.timings.length == other.timings.length);
        for (i = 0; i < this.timings.length; ++i) {
            int n = i;
            this.timings[n] = this.timings[n] + other.timings[i];
        }
        assert (this.counts.length == other.counts.length);
        for (i = 0; i < this.counts.length; ++i) {
            int n = i;
            this.counts[n] = this.counts[n] + other.counts[i];
        }
    }
}

