/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Counter;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.lease.Releasable;
import org.codelibs.elasticsearch.common.lease.Releasables;
import org.codelibs.elasticsearch.common.unit.TimeValue;
import org.codelibs.elasticsearch.common.util.BigArrays;
import org.codelibs.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.codelibs.elasticsearch.common.util.iterable.Iterables;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.query.ParsedQuery;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.SearchExtBuilder;
import org.codelibs.elasticsearch.search.aggregations.SearchContextAggregations;
import org.codelibs.elasticsearch.search.fetch.StoredFieldsContext;
import org.codelibs.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.codelibs.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.codelibs.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.codelibs.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.codelibs.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.codelibs.elasticsearch.search.rescore.RescoreSearchContext;
import org.codelibs.elasticsearch.search.sort.SortAndFormats;
import org.codelibs.elasticsearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
extends AbstractRefCounted
implements Releasable {
    public static final int DEFAULT_TERMINATE_AFTER = 0;
    private Map<Lifetime, List<Releasable>> clearables = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InnerHitsContext innerHitsContext;

    protected SearchContext() {
        super("search_context");
    }

    public abstract boolean isCancelled();

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.decRef();
        }
    }

    @Override
    protected final void closeInternal() {
        try {
            this.clearReleasables(Lifetime.CONTEXT);
        }
        finally {
            this.doClose();
        }
    }

    @Override
    protected void alreadyClosed() {
        throw new IllegalStateException("search context is already closed can't increment refCount current count [" + this.refCount() + "]");
    }

    protected abstract void doClose();

    public abstract void preProcess(boolean var1);

    public abstract Query searchFilter(String[] var1);

    public abstract long id();

    public abstract String source();

    public abstract int numberOfShards();

    public abstract float queryBoost();

    public abstract long getOriginNanoTime();

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract void addSearchExt(SearchExtBuilder var1);

    public abstract SearchExtBuilder getSearchExt(String var1);

    public abstract SearchContextHighlight highlight();

    public abstract void highlight(SearchContextHighlight var1);

    public InnerHitsContext innerHits() {
        if (this.innerHitsContext == null) {
            this.innerHitsContext = new InnerHitsContext();
        }
        return this.innerHitsContext;
    }

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract List<RescoreSearchContext> rescore();

    public abstract void addRescore(RescoreSearchContext var1);

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract DocValueFieldsContext docValueFieldsContext();

    public abstract SearchContext docValueFieldsContext(DocValueFieldsContext var1);

    public abstract BigArrays bigArrays();

    public abstract TimeValue timeout();

    public abstract void timeout(TimeValue var1);

    public abstract int terminateAfter();

    public abstract void terminateAfter(int var1);

    public abstract boolean lowLevelCancellation();

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(SortAndFormats var1);

    public abstract SortAndFormats sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext searchAfter(FieldDoc var1);

    public abstract FieldDoc searchAfter();

    public abstract SearchContext parsedPostFilter(ParsedQuery var1);

    public abstract ParsedQuery parsedPostFilter();

    public abstract Query aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasStoredFields();

    public abstract boolean hasStoredFieldsContext();

    public abstract boolean storedFieldsRequested();

    public abstract StoredFieldsContext storedFieldsContext();

    public abstract SearchContext storedFieldsContext(StoredFieldsContext var1);

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract void accessed(long var1);

    public abstract long lastAccessTime();

    public abstract long keepAlive();

    public abstract void keepAlive(long var1);

    public void addReleasable(Releasable releasable, Lifetime lifetime) {
        List<Releasable> releasables;
        if (this.clearables == null) {
            this.clearables = new HashMap<Lifetime, List<Releasable>>();
        }
        if ((releasables = this.clearables.get((Object)lifetime)) == null) {
            releasables = new ArrayList<Releasable>();
            this.clearables.put(lifetime, releasables);
        }
        releasables.add(releasable);
    }

    public void clearReleasables(Lifetime lifetime) {
        if (this.clearables != null) {
            ArrayList<List<Releasable>> releasables = new ArrayList<List<Releasable>>();
            for (Lifetime lc : Lifetime.values()) {
                if (lc.compareTo(lifetime) > 0) break;
                List<Releasable> remove = this.clearables.remove((Object)lc);
                if (remove == null) continue;
                releasables.add(remove);
            }
            Releasables.close(Iterables.flatten(releasables));
        }
    }

    public final boolean hasOnlySuggest() {
        throw new UnsupportedOperationException();
    }

    public abstract MappedFieldType smartNameFieldType(String var1);

    public abstract Counter timeEstimateCounter();

    public abstract Map<Class<?>, Collector> queryCollectors();

    public abstract QueryShardContext getQueryShardContext();

    public String toString() {
        throw new UnsupportedOperationException();
    }

    public static enum Lifetime {
        COLLECTION,
        PHASE,
        CONTEXT;

    }
}

