/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Streamable;
import org.codelibs.elasticsearch.common.text.Text;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;

public class HighlightField
implements ToXContent,
Streamable {
    private String name;
    private Text[] fragments;

    HighlightField() {
    }

    public HighlightField(String name, Text[] fragments) {
        this.name = Objects.requireNonNull(name, "missing highlight field name");
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    public Text[] fragments() {
        return this.fragments;
    }

    public Text[] getFragments() {
        return this.fragments();
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    public static HighlightField readHighlightField(StreamInput in) throws IOException {
        HighlightField field = new HighlightField();
        field.readFrom(in);
        return field;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        if (in.readBoolean()) {
            int size = in.readVInt();
            if (size == 0) {
                this.fragments = Text.EMPTY_ARRAY;
            } else {
                this.fragments = new Text[size];
                for (int i = 0; i < size; ++i) {
                    this.fragments[i] = in.readText();
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fragments.length);
            for (Text fragment : this.fragments) {
                out.writeText(fragment);
            }
        }
    }

    public static HighlightField fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        Text[] fragments = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_ARRAY) {
            fragments = HighlightField.parseValues(parser);
        } else if (token == XContentParser.Token.VALUE_NULL) {
            fragments = null;
        } else {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token type [" + (Object)((Object)token) + "]", new Object[0]);
        }
        return new HighlightField(fieldName, fragments);
    }

    private static Text[] parseValues(XContentParser parser) throws IOException {
        ArrayList<Text> values = new ArrayList<Text>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            values.add(new Text(parser.text()));
        }
        return values.toArray(new Text[values.size()]);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.name);
        if (this.fragments == null) {
            builder.nullValue();
        } else {
            builder.startArray();
            for (Text fragment : this.fragments) {
                builder.value(fragment);
            }
            builder.endArray();
        }
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightField other = (HighlightField)obj;
        return Objects.equals(this.name, other.name) && Arrays.equals(this.fragments, other.fragments);
    }

    public final int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.fragments));
    }
}

