/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.fetch.subphase.highlight;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.util.CollectionUtil;
import org.codelibs.elasticsearch.index.mapper.FieldMapper;

public final class FragmentBuilderHelper {
    private FragmentBuilderHelper() {
    }

    public static FieldFragList.WeightedFragInfo fixWeightedFragInfo(FieldMapper mapper, Field[] values, FieldFragList.WeightedFragInfo fragInfo) {
        assert (fragInfo != null) : "FragInfo must not be null";
        assert (mapper.fieldType().name().equals(values[0].name())) : "Expected FieldMapper for field " + values[0].name();
        if (!fragInfo.getSubInfos().isEmpty() && FragmentBuilderHelper.containsBrokenAnalysis((Analyzer)mapper.fieldType().indexAnalyzer())) {
            List subInfos = fragInfo.getSubInfos();
            CollectionUtil.introSort((List)subInfos, (o1, o2) -> {
                int startOffset = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o1.getTermsOffsets().get(0)).getStartOffset();
                int startOffset2 = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o2.getTermsOffsets().get(0)).getStartOffset();
                return FragmentBuilderHelper.compare(startOffset, startOffset2);
            });
            return new FieldFragList.WeightedFragInfo(Math.min(((FieldPhraseList.WeightedPhraseInfo.Toffs)((FieldFragList.WeightedFragInfo.SubInfo)fragInfo.getSubInfos().get(0)).getTermsOffsets().get(0)).getStartOffset(), fragInfo.getStartOffset()), fragInfo.getEndOffset(), subInfos, fragInfo.getTotalBoost());
        }
        return fragInfo;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static boolean containsBrokenAnalysis(Analyzer analyzer) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }
}

