/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.fetch.subphase;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.codelibs.elasticsearch.search.internal.SearchContext;

public final class InnerHitsContext {
    private final Map<String, BaseInnerHits> innerHits;

    public InnerHitsContext() {
        this.innerHits = new HashMap<String, BaseInnerHits>();
    }

    public InnerHitsContext(Map<String, BaseInnerHits> innerHits) {
        this.innerHits = Objects.requireNonNull(innerHits);
    }

    public Map<String, BaseInnerHits> getInnerHits() {
        return this.innerHits;
    }

    public void addInnerHitDefinition(BaseInnerHits innerHit) {
        if (this.innerHits.containsKey(innerHit.getName())) {
            throw new IllegalArgumentException("inner_hit definition with the name [" + innerHit.getName() + "] already exists. Use a different inner_hit name or define one explicitly");
        }
        this.innerHits.put(innerHit.getName(), innerHit);
    }

    public static abstract class BaseInnerHits {
        private final String name;
        private InnerHitsContext childInnerHits;

        protected BaseInnerHits(String name, SearchContext context) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public InnerHitsContext innerHits() {
            return this.childInnerHits;
        }

        public void setChildInnerHits(Map<String, BaseInnerHits> childInnerHits) {
            this.childInnerHits = new InnerHitsContext(childInnerHits);
        }
    }
}

