/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.Scorer;
import org.codelibs.elasticsearch.common.lucene.ScorerAware;
import org.codelibs.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.codelibs.elasticsearch.script.LeafSearchScript;
import org.codelibs.elasticsearch.search.aggregations.AggregationExecutionException;

public class ScriptDoubleValues
extends SortingNumericDoubleValues
implements ScorerAware {
    final LeafSearchScript script;

    public ScriptDoubleValues(LeafSearchScript script) {
        this.script = script;
    }

    @Override
    public void setDocument(int docId) {
        this.script.setDocument(docId);
        Object value = this.script.run();
        if (value == null) {
            this.resize(0);
        } else if (value instanceof Number) {
            this.resize(1);
            this.values[0] = ((Number)value).doubleValue();
        } else if (value.getClass().isArray()) {
            this.resize(Array.getLength(value));
            for (int i = 0; i < this.count(); ++i) {
                this.values[i] = ((Number)Array.get(value, i)).doubleValue();
            }
        } else if (value instanceof Collection) {
            this.resize(((Collection)value).size());
            int i = 0;
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                this.values[i] = ((Number)it.next()).doubleValue();
                ++i;
            }
            assert (i == this.count());
        } else {
            throw new AggregationExecutionException("Unsupported script value [" + value + "]");
        }
        this.sort();
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }
}

