/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.support;

import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.xcontent.ObjectParser;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.script.Script;
import org.codelibs.elasticsearch.search.aggregations.support.ValueType;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.joda.time.DateTimeZone;

public final class ValuesSourceParserHelper {
    static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);

    private ValuesSourceParserHelper() {
    }

    public static void declareAnyFields(ObjectParser<? extends ValuesSourceAggregationBuilder<ValuesSource, ?>, QueryParseContext> objectParser, boolean scriptable, boolean formattable) {
        ValuesSourceParserHelper.declareFields(objectParser, scriptable, formattable, false, ValuesSourceType.ANY, null);
    }

    public static void declareNumericFields(ObjectParser<? extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, ?>, QueryParseContext> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware) {
        ValuesSourceParserHelper.declareFields(objectParser, scriptable, formattable, timezoneAware, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
    }

    public static void declareBytesFields(ObjectParser<? extends ValuesSourceAggregationBuilder<ValuesSource.Bytes, ?>, QueryParseContext> objectParser, boolean scriptable, boolean formattable) {
        ValuesSourceParserHelper.declareFields(objectParser, scriptable, formattable, false, ValuesSourceType.BYTES, ValueType.STRING);
    }

    public static void declareGeoFields(ObjectParser<? extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, ?>, QueryParseContext> objectParser, boolean scriptable, boolean formattable) {
        ValuesSourceParserHelper.declareFields(objectParser, scriptable, formattable, false, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    private static <VS extends ValuesSource> void declareFields(ObjectParser<? extends ValuesSourceAggregationBuilder<VS, ?>, QueryParseContext> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        objectParser.declareField(ValuesSourceAggregationBuilder::field, XContentParser::text, new ParseField("field", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareField(ValuesSourceAggregationBuilder::missing, XContentParser::objectText, new ParseField("missing", new String[0]), ObjectParser.ValueType.VALUE);
        objectParser.declareField(ValuesSourceAggregationBuilder::valueType, p -> {
            ValueType valueType2 = ValueType.resolveForScript(p.text());
            if (targetValueType != null && valueType2.isNotA(targetValueType)) {
                throw new ParsingException(p.getTokenLocation(), "Aggregation [" + objectParser.getName() + "] was configured with an incompatible value type [" + valueType2 + "]. It can only work on value of type [" + targetValueType + "]", new Object[0]);
            }
            return valueType2;
        }, new ParseField("value_type", "valueType"), ObjectParser.ValueType.STRING);
        if (formattable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::format, XContentParser::text, new ParseField("format", new String[0]), ObjectParser.ValueType.STRING);
        }
        if (scriptable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::script, Script::parse, Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        }
        if (timezoneAware) {
            objectParser.declareField(ValuesSourceAggregationBuilder::timeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return DateTimeZone.forID((String)p.text());
                }
                return DateTimeZone.forOffsetHours((int)p.intValue());
            }, TIME_ZONE, ObjectParser.ValueType.LONG);
        }
    }
}

