/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.search.aggregations.Aggregator;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactories;
import org.codelibs.elasticsearch.search.aggregations.AggregatorFactory;
import org.codelibs.elasticsearch.search.aggregations.InternalAggregation;
import org.codelibs.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSource;
import org.codelibs.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.codelibs.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public abstract class ValuesSourceAggregatorFactory<VS extends ValuesSource, AF extends ValuesSourceAggregatorFactory<VS, AF>>
extends AggregatorFactory<AF> {
    protected ValuesSourceConfig<VS> config;

    public ValuesSourceAggregatorFactory(String name, InternalAggregation.Type type, ValuesSourceConfig<VS> config, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, type, context, parent, subFactoriesBuilder, metaData);
        this.config = config;
    }

    public DateTimeZone timeZone() {
        return this.config.timezone();
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        VS vs = this.config.toValuesSource(this.context.getQueryShardContext());
        if (vs == null) {
            return this.createUnmapped(parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(vs, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    protected abstract Aggregator createUnmapped(Aggregator var1, List<PipelineAggregator> var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(VS var1, Aggregator var2, boolean var3, List<PipelineAggregator> var4, Map<String, Object> var5) throws IOException;
}

